/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.events;

import com.alexander.rootoffear.particles.BlockWrappingParticle;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rootoffear", value={Dist.CLIENT})
public class RenderBlockWrappingParticlesEvent {
    public static final List<BlockWrappingParticle> queuedBlockWrappingParticles = Lists.newArrayList();

    @SubscribeEvent
    public static void renderBlockWrappingParticles(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES)) {
            Minecraft minecraft = Minecraft.m_91087_();
            PoseStack poseStack = event.getPoseStack();
            ClientLevel level = minecraft.f_91073_;
            Vec3 cameraPos = minecraft.f_91063_.m_109153_().m_90583_();
            for (BlockWrappingParticle particle : queuedBlockWrappingParticles) {
                poseStack.m_85836_();
                Vec3 particlePos = particle.getPos();
                poseStack.m_85837_(particlePos.f_82479_ - cameraPos.f_82479_, particlePos.f_82480_ - cameraPos.f_82480_, particlePos.f_82481_ - cameraPos.f_82481_);
                BlockPos pos = BlockPos.m_274446_((Position)particlePos);
                PoseStack.Pose posestack$pose1 = poseStack.m_85850_();
                RenderSystem.setShader(GameRenderer::m_172829_);
                SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(minecraft.m_91269_().m_110104_().m_6299_(particle.renderType()), posestack$pose1.m_252922_(), posestack$pose1.m_252943_(), 1.0f);
                ModelData modelData = level.getModelDataManager().getAt(pos);
                minecraft.m_91289_().renderBreakingTexture(level.m_8055_(pos), pos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)vertexconsumer1, modelData == null ? ModelData.EMPTY : modelData);
                poseStack.m_85849_();
            }
            queuedBlockWrappingParticles.clear();
        }
    }
}

