/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.events;

import com.alexander.rootoffear.network.ClientboundStartPlayerMovementPacket;
import com.alexander.rootoffear.network.Messages;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rootoffear")
public class PlayerMovementEvents {
    public static final List<PlayerMovement> clientPlayerMovements = Lists.newArrayList();
    public static final List<PlayerMovement> serverPlayerMovements = Lists.newArrayList();

    @SubscribeEvent
    public static void tickPlayerMovements(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ArrayList toRemove = Lists.newArrayList();
            for (PlayerMovement movement : event.side == LogicalSide.CLIENT ? clientPlayerMovements : serverPlayerMovements) {
                movement.tick();
                if (!movement.done) continue;
                toRemove.add(movement);
            }
            for (PlayerMovement movement : toRemove) {
                if (event.side == LogicalSide.CLIENT) {
                    clientPlayerMovements.remove(movement);
                    continue;
                }
                serverPlayerMovements.remove(movement);
            }
        }
    }

    public static boolean alreadyHasMovement(Entity player, Entity cause, int type) {
        for (PlayerMovement movement : serverPlayerMovements) {
            if (movement.player != player || movement.cause != cause || movement.type != type) continue;
            return true;
        }
        return false;
    }

    public static void addPlayerMovement(Entity player, Entity cause, int type) {
        if (!PlayerMovementEvents.alreadyHasMovement(player, cause, type)) {
            serverPlayerMovements.add(new PlayerMovement(player, cause, type));
            Messages.sendToAllPlayers(new ClientboundStartPlayerMovementPacket(player, cause, type));
        }
    }

    public static void addClientPlayerMovement(int playerID, int causeID, int type) {
        clientPlayerMovements.add(new PlayerMovement(Minecraft.m_91087_().f_91073_.m_6815_(playerID), Minecraft.m_91087_().f_91073_.m_6815_(causeID), type));
    }

    public static class PlayerMovement {
        public final Player player;
        public final Entity cause;
        public final int type;
        public int tickCount;
        public boolean done = false;
        public Pose oldPose;

        public PlayerMovement(Entity player, Entity cause, int type) {
            if (player instanceof Player) {
                Player realPlayer;
                this.player = realPlayer = (Player)player;
            } else {
                this.player = null;
                this.done = true;
            }
            if (type == 0 && cause instanceof LivingEntity) {
                LivingEntity livingCause = (LivingEntity)cause;
                this.player.m_20219_(PositionUtils.getOffsetPos(cause, 0.0, 3.0, 4.0, 0.0f, livingCause.f_20883_));
            }
            this.oldPose = cause.m_20089_();
            this.cause = cause;
            this.type = type;
        }

        public void tick() {
            if (!this.done) {
                if (MiscUtils.inSurvivalMode((LivingEntity)this.player) && MiscUtils.isEntityValid(this.cause)) {
                    if (this.type == 0) {
                        Entity entity;
                        if (this.cause.m_20191_().m_82377_(5.0, 10.0, 5.0).m_82381_(this.player.m_20191_()) && (entity = this.cause) instanceof LivingEntity) {
                            LivingEntity livingCause = (LivingEntity)entity;
                            Vec3 finalVec = Vec3.f_82478_;
                            Vec3 targetVec1 = new Vec3(0.0, 3.0, 4.0);
                            Vec3 targetVec2 = new Vec3(0.0, 4.5, 3.0);
                            Vec3 targetVec3 = new Vec3(0.0, -0.5, 4.5);
                            int ticks = this.tickCount % 40;
                            if (ticks <= 10) {
                                finalVec = targetVec1.m_165921_(targetVec2, (double)((float)ticks / 10.0f));
                            } else if (ticks < 14) {
                                finalVec = targetVec2;
                            } else if (ticks <= 17) {
                                finalVec = targetVec2.m_165921_(targetVec3, (double)((float)(ticks - 14) / 3.0f));
                            } else if (ticks < 28) {
                                finalVec = targetVec3;
                            } else if (ticks <= 40) {
                                finalVec = targetVec3.m_165921_(targetVec1, (double)((float)(ticks - 27) / 13.0f));
                            }
                            Vec3 pos = PositionUtils.getOffsetPos(this.cause, finalVec.f_82479_, finalVec.f_82480_, finalVec.f_82481_, 0.0f, livingCause.f_20883_);
                            double distance = Math.max(PositionUtils.distanceTo((Entity)this.player, pos), 1.0f);
                            this.player.m_20256_(new Vec3((pos.f_82479_ - this.player.m_20185_()) / distance, (pos.f_82480_ - this.player.m_20186_()) / distance, (pos.f_82481_ - this.player.m_20189_()) / distance));
                        }
                        if (this.oldPose != this.cause.m_20089_() && this.cause.m_20089_() == Pose.STANDING) {
                            this.done = true;
                        }
                        this.oldPose = this.cause.m_20089_();
                    } else if (this.type == 1 && this.cause.m_20191_().m_165887_(this.cause.m_20186_() - 2.0).m_82381_(this.player.m_20191_())) {
                        Vec3 targetVec1 = this.cause.m_20182_().m_82492_(0.0, 0.0, 0.0);
                        Vec3 targetVec2 = this.cause.m_20182_().m_82492_(0.0, (double)this.player.m_20206_(), 0.0);
                        Vec3 target = this.tickCount <= 10 ? targetVec1 : targetVec1.m_165921_(targetVec2, (double)((float)(this.tickCount - 10) / 140.0f));
                        this.player.m_20334_(0.0, 0.0, 0.0);
                        double xo = this.player.f_19854_;
                        double xOld = this.player.f_19790_;
                        double yo = this.player.f_19855_;
                        double yOld = this.player.f_19791_;
                        double zo = this.player.f_19856_;
                        double zOld = this.player.f_19792_;
                        this.player.m_20219_(target);
                        this.player.f_19854_ = xo;
                        this.player.f_19790_ = xOld;
                        this.player.f_19855_ = yo;
                        this.player.f_19791_ = yOld;
                        this.player.f_19856_ = zo;
                        this.player.f_19792_ = zOld;
                        if (this.tickCount >= 150) {
                            this.done = true;
                        }
                    }
                    ++this.tickCount;
                } else {
                    this.done = true;
                }
            }
        }
    }
}

