/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.events;

import com.alexander.rootoffear.network.ClientboundShakeCameraPacket;
import com.alexander.rootoffear.network.Messages;
import com.alexander.rootoffear.utils.PositionUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rootoffear", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CameraShakeEvents {
    public Random random = new Random();
    public static NonNullList<CameraShakeHandler> cameraShakes = NonNullList.m_122779_();
    public static int cameraEntityLastTickCount;

    @SubscribeEvent
    protected static void cameraShake(ViewportEvent.ComputeCameraAngles event) {
        for (int i = 0; i < cameraShakes.size(); ++i) {
            CameraShakeHandler handler = (CameraShakeHandler)cameraShakes.get(i);
            Entity cameraEntity = Minecraft.m_91087_().f_91075_;
            if (handler == null) continue;
            if (handler.time <= 0) {
                cameraShakes.remove((Object)handler);
            }
            if (event.getCamera().m_90592_().f_19797_ != cameraEntityLastTickCount && handler.time > 0) {
                --handler.time;
            }
            if (cameraEntity == null || handler.time <= 0 || !(PositionUtils.distanceTo(cameraEntity, handler.causePosition) <= (float)handler.range)) continue;
            CameraShakeEvents.shakeCamera(event, cameraEntity, handler.amount * ((float)handler.time / (float)handler.duration));
        }
        cameraEntityLastTickCount = event.getCamera().m_90592_().f_19797_;
    }

    public static void addCameraShake(Level level, int duration, float amount, BlockPos causePosition, int range) {
        if (level == null || level.f_46443_) {
            cameraShakes.add(0, (Object)new CameraShakeHandler(amount, duration, duration, causePosition, range));
        }
        if (level != null && !level.f_46443_) {
            for (Player player : level.m_6907_()) {
                if (!(player instanceof ServerPlayer)) continue;
                Messages.sendToPlayer(new ClientboundShakeCameraPacket(duration, amount, causePosition, range), (ServerPlayer)player);
            }
        }
    }

    private static void shakeCamera(ViewportEvent.ComputeCameraAngles event, Entity cameraEntity, float amount) {
        if (!Minecraft.m_91087_().m_91104_()) {
            float delta = Minecraft.m_91087_().m_91297_();
            float ticksExistedDelta = (float)cameraEntity.f_19797_ + delta;
            float finalAmount = amount * 0.1f;
            event.setPitch((float)Mth.m_14139_((double)Minecraft.m_91087_().getPartialTick(), (double)event.getPitch(), (double)((double)event.getPitch() + (double)finalAmount * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0)));
            event.setYaw((float)Mth.m_14139_((double)Minecraft.m_91087_().getPartialTick(), (double)event.getYaw(), (double)((double)event.getYaw() + (double)finalAmount * Math.cos(ticksExistedDelta * 5.0f + 9.0f) * 25.0)));
            event.setRoll((float)Mth.m_14139_((double)Minecraft.m_91087_().getPartialTick(), (double)event.getRoll(), (double)((double)event.getRoll() + (double)finalAmount * Math.cos(ticksExistedDelta * 4.0f) * 25.0)));
        }
    }

    public static class CameraShakeHandler {
        public float amount;
        public int duration;
        public int time;
        public BlockPos causePosition;
        public int range;

        public CameraShakeHandler(float amount, int duration, int time, BlockPos causePosition, int range) {
            this.amount = amount;
            this.duration = duration;
            this.time = duration;
            this.causePosition = causePosition;
            this.range = range;
        }
    }
}

