/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.events;

import com.alexander.rootoffear.config.RoFCommonConfig;
import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.init.TagInit;
import com.alexander.rootoffear.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rootoffear")
public class AddCooldownsToPlacedLightSourcesEvent {
    @SubscribeEvent
    public static void addCooldownsToPlacedBlocks(BlockEvent.EntityPlaceEvent event) {
        AddCooldownsToPlacedLightSourcesEvent.tryAddCooldowns(event.getLevel(), event.getEntity(), event.getPos());
    }

    public static void tryAddCooldowns(LevelAccessor level, Entity entity, BlockPos pos) {
        Player player;
        if (((Boolean)RoFCommonConfig.wilted_adds_cooldowns_to_nearby_light_items.get()).booleanValue() && !level.m_5776_() && entity instanceof Player && MiscUtils.inSurvivalMode((LivingEntity)(player = (Player)entity)) && (level.m_7146_(pos) > 0 || level.m_6425_(pos).getFluidType().getLightLevel() > 0)) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_45976_(Wilted.class, player.m_20191_().m_82400_(30.0)).size() > 0) {
                serverLevel.m_247517_(null, pos, (SoundEvent)SoundEventInit.WILTED_CURSE_ITEM.get(), SoundSource.HOSTILE);
                for (ItemStack stack : player.m_150109_().f_35975_) {
                    if (!AddCooldownsToPlacedLightSourcesEvent.shouldAddCooldown(stack, serverLevel, pos)) continue;
                    player.m_36335_().m_41524_(stack.m_41720_(), 200);
                }
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!AddCooldownsToPlacedLightSourcesEvent.shouldAddCooldown(stack, serverLevel, pos)) continue;
                    player.m_36335_().m_41524_(stack.m_41720_(), 200);
                }
                for (ItemStack stack : player.m_150109_().f_35976_) {
                    if (!AddCooldownsToPlacedLightSourcesEvent.shouldAddCooldown(stack, serverLevel, pos)) continue;
                    player.m_36335_().m_41524_(stack.m_41720_(), 200);
                }
            }
        }
    }

    public static boolean shouldAddCooldown(ItemStack stack, ServerLevel level, BlockPos pos) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_().getLightEmission(blockItem.m_40614_().m_49966_(), (BlockGetter)level, pos) > 0 || stack.m_204117_(TagInit.Items.WILTED_ADDS_COOLDOWN_TO);
    }
}

