/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.entities;

import com.alexander.rootoffear.entities.AbstractHurtableEntity;
import com.alexander.rootoffear.events.PlayerMovementEvents;
import com.alexander.rootoffear.init.EntityTypeInit;
import com.alexander.rootoffear.init.ParticleTypeInit;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.utils.MiscUtils;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class WiltedHands
extends AbstractHurtableEntity {
    public AnimationState grabAnimationState = new AnimationState();
    public LivingEntity target;

    public WiltedHands(EntityType<? extends WiltedHands> type, Level level) {
        super(type, level);
    }

    public WiltedHands(Level level, Vec3 pos, float yRot, LivingEntity target) {
        this((EntityType<? extends WiltedHands>)((EntityType)EntityTypeInit.WILTED_HANDS.get()), level);
        this.m_146884_(pos);
        this.m_146922_(yRot);
        this.target = target;
    }

    @Override
    public void m_7822_(byte event) {
        if (event == 5) {
            for (int i = 0; i < 100; ++i) {
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_BREAK.get(), this.m_20208_(0.85), this.m_20187_(), this.m_20262_(0.85), 0.0, 0.0, 0.0);
            }
        } else if (event == 7) {
            this.grabAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(event);
        }
    }

    @Override
    public SoundEvent hurtSound() {
        return (SoundEvent)SoundEventInit.WILTED_SWAY.get();
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateHurtable();
        if (!this.m_9236_().m_5776_() && MiscUtils.inSurvivalMode(this.target) && this.m_20191_().m_165887_(this.m_20186_() - 2.0).m_82381_(this.target.m_20191_())) {
            this.target.m_6853_(false);
            this.target.m_183634_();
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                PlayerMovementEvents.addPlayerMovement((Entity)serverPlayer, this, 1);
            } else {
                Vec3 targetVec1 = this.m_20182_().m_82492_(0.0, 0.0, 0.0);
                Vec3 targetVec2 = this.m_20182_().m_82492_(0.0, (double)this.target.m_20206_(), 0.0);
                Vec3 targetPos = this.f_19797_ <= 10 ? targetVec1 : targetVec1.m_165921_(targetVec2, (double)((float)(this.f_19797_ - 10) / 140.0f));
                this.target.m_146884_(targetPos);
                this.target.m_20334_(0.0, 0.0, 0.0);
            }
        }
        this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), this.m_20208_(0.8), this.m_20186_(), this.m_20262_(0.8), 0.0, 0.0, 0.0);
    }

    @Override
    public void onKilled() {
        if (MiscUtils.inSurvivalMode(this.target) && this.m_20191_().m_165887_(this.m_20186_() - 2.0).m_82381_(this.target.m_20191_())) {
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                serverPlayer.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            } else {
                this.target.m_20219_(this.m_20182_());
            }
        }
        this.m_5496_((SoundEvent)SoundEventInit.WILTED_STEP.get(), this.getSoundVolume(), this.getVoicePitch() * 2.0f);
        super.onKilled();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public int maxHits() {
        return 10;
    }

    @Override
    public int hurtCooldown() {
        return 8;
    }

    @Override
    public int maxLifeTime() {
        return 155;
    }

    @Override
    public boolean discardAfterLifeTimeReached() {
        return true;
    }

    @Override
    public AnimationState hurtAnimationState() {
        return null;
    }

    protected void m_8097_() {
    }
}

