/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.entities;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public abstract class AbstractHurtableEntity
extends Entity {
    public int remainingHits = this.maxHits();
    public int hurtCooldown;
    public int lifeTime = 0;
    public boolean killed = false;

    public AbstractHurtableEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public abstract int maxHits();

    public abstract int hurtCooldown();

    public abstract int maxLifeTime();

    public abstract AnimationState hurtAnimationState();

    public boolean discardAfterLifeTimeReached() {
        return false;
    }

    public SoundEvent hurtSound() {
        return null;
    }

    public float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().m_5776_() && !this.m_6673_(source) && amount > 0.0f && this.hurtCooldown <= 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            --this.remainingHits;
            this.hurtCooldown = this.hurtCooldown();
            if (this.hurtSound() != null) {
                this.m_5496_(this.hurtSound(), this.getSoundVolume(), this.getVoicePitch());
            }
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || this.killed;
    }

    public void updateHurtable() {
        if (!this.m_9236_().m_5776_() && !this.killed && this.remainingHits <= 0 && this.hurtCooldown <= Math.max(0, this.hurtCooldown() - 5)) {
            this.onKilled();
            this.killed = true;
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        if (this.hurtCooldown > 0) {
            --this.hurtCooldown;
        }
        if (this.lifeTime > this.maxLifeTime()) {
            if (this.discardAfterLifeTimeReached()) {
                this.m_146870_();
            } else if (this.f_19797_ % 40 == 0) {
                this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
            }
        }
        ++this.lifeTime;
    }

    public void onKilled() {
        this.m_9236_().m_7605_((Entity)this, (byte)5);
        this.m_6074_();
    }

    public void m_7822_(byte event) {
        if (event == 4) {
            if (this.hurtAnimationState() != null) {
                this.hurtAnimationState().m_216977_(this.f_19797_);
            }
            this.hurtCooldown = this.hurtCooldown() / 2;
        } else if (event == 5) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        } else if (event == 6) {
            this.killed = true;
        } else {
            super.m_7822_(event);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("RemainingHits")) {
            this.remainingHits = tag.m_128451_("RemainingHits");
        }
        if (tag.m_128441_("LifeTime")) {
            this.lifeTime = tag.m_128451_("LifeTime");
        }
        if (tag.m_128441_("Killed")) {
            this.killed = tag.m_128471_("Killed");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("RemainingHits", this.remainingHits);
        tag.m_128405_("LifeTime", this.lifeTime);
        tag.m_128379_("Killed", this.killed);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }
}

