/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.customspawners;

import com.alexander.rootoffear.capabilities.RoFLevelCapabilityProvider;
import com.alexander.rootoffear.config.RoFCommonConfig;
import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.init.EntityTypeInit;
import com.alexander.rootoffear.utils.MiscUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;

public class WiltedSpawner
implements CustomSpawner {
    private static final int FIND_SPAWN_LOCATION_ATTEMPTS = 20;
    public long nextSpawnDay;

    public int m_7995_(ServerLevel level, boolean p_35923_, boolean p_35924_) {
        level.getCapability(RoFLevelCapabilityProvider.CAP).ifPresent(capability -> {
            if (capability.getOldWiltedSpawnCooldown() != -1) {
                capability.setNextSpawnDay((level.m_46468_() + (long)capability.getOldWiltedSpawnCooldown()) / 24000L);
                capability.setOldWiltedSpawnCooldown(-1);
            }
            this.nextSpawnDay = capability.getNextSpawnDay();
        });
        if (this.spawn(level)) {
            return 1;
        }
        return 0;
    }

    private boolean spawn(ServerLevel level) {
        Wilted wilted;
        ServerPlayer player = level.m_8890_();
        if (player == null || !MiscUtils.isEntityInValidWiltedSpawnBiome((Entity)player) || level.m_46468_() / 24000L < this.nextSpawnDay || !level.m_6042_().m_63967_() && level.m_7445_() < 10) {
            return false;
        }
        BlockPos blockpos2 = this.findSpawnPositionNear(level, (Player)player);
        if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)level, blockpos2) && (wilted = (Wilted)((EntityType)EntityTypeInit.WILTED.get()).m_262496_(level, blockpos2, MobSpawnType.EVENT)) != null) {
            level.getCapability(RoFLevelCapabilityProvider.CAP).ifPresent(capability -> {
                capability.setWiltedID(wilted.m_20148_());
                capability.setNextSpawnDay(level.m_46468_() / 24000L + (long)Mth.m_216287_((RandomSource)level.m_213780_(), (int)((Integer)RoFCommonConfig.min_wilted_spawn_cooldown.get()), (int)((Integer)RoFCommonConfig.max_wilted_spawn_cooldown.get())));
                capability.setNextSoundTime(0L);
            });
            wilted.setDisguised(true);
            wilted.setNaturallySpawned(true);
            wilted.ultimateTargetID = player.m_20148_();
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findSpawnPositionNear(ServerLevel level, Player player) {
        return Wilted.findSpawnablePosition(player.m_20183_(), level, 96, 112, 0, 20, true);
    }

    private boolean hasEnoughSpace(BlockGetter p_35926_, BlockPos p_35927_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_35927_, (BlockPos)p_35927_.m_7918_(1, 2, 1))) {
            if (p_35926_.m_8055_(blockpos).m_60812_(p_35926_, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

