/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.ai.goals.wilted;

import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.events.CameraShakeEvents;
import com.alexander.rootoffear.events.PlayerMovementEvents;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WiltedGrabAttackGoal
extends Goal {
    public Wilted mob;
    @Nullable
    public LivingEntity target;
    public int nextUseTime;
    public int useTicks;
    public boolean canContinue;

    public WiltedGrabAttackGoal(Wilted mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.mob = mob;
        this.target = mob.m_5448_();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return !this.mob.isDisguised() && this.mob.f_19797_ >= this.nextUseTime && !this.mob.m_6060_() && MiscUtils.isEntityValid(this.target) && (MiscUtils.isEntityAttackable((LivingEntity)this.mob, this.target, 5.0) || this.mob.isPhasingThroughWall() && this.mob.m_9236_().m_45517_(LightLayer.BLOCK, this.target.m_20183_()) < 3 && this.mob.m_20191_().m_82377_(3.5, 0.0, 3.5).m_82381_(this.target.m_20191_()));
    }

    public boolean m_8045_() {
        return this.canContinue && !this.mob.m_6060_();
    }

    public void m_8056_() {
        this.mob.setSilentTimer(0);
        this.mob.startAnimation(0);
        this.mob.m_20124_(Pose.SPIN_ATTACK);
        this.useTicks = 0;
        this.canContinue = true;
        Vec3 pos = this.pickUpPos();
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PlayerMovementEvents.addPlayerMovement((Entity)player, (Entity)this.mob, 0);
        } else {
            this.target.m_146884_(pos);
        }
    }

    public void m_8037_() {
        this.mob.m_21573_().m_26573_();
        AABB bb = this.mob.m_20191_().m_82377_(5.0, 10.0, 5.0);
        if (MiscUtils.inSurvivalMode(this.target) && bb.m_82381_(this.target.m_20191_())) {
            this.moveTargetToPickUpPos();
            if (this.mob.m_6060_()) {
                this.target.m_20254_(5);
            }
            if (this.useTicks % 40 == 0) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.WILTED_ATTACK.get(), this.mob.m_6121_(), 1.0f);
            }
            if (this.useTicks % 40 == 19) {
                this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 20.0f);
                CameraShakeEvents.addCameraShake(this.mob.m_9236_(), 10, 2.0f, this.target.m_20183_(), 15);
                MiscUtils.disableShield(this.target, 60);
                for (LivingEntity entity2 : this.mob.m_9236_().m_45971_(LivingEntity.class, Wilted.TARGETING, (LivingEntity)this.mob, this.target.m_20191_().m_82400_(2.0))) {
                    if (entity2 == this.target || entity2 == this.mob) continue;
                    entity2.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 10.0f);
                    MiscUtils.disableShield(entity2, 60);
                }
                if (MiscUtils.isEntityValid(this.mob.m_5448_()) && this.mob.m_5448_() != this.target) {
                    this.canContinue = false;
                }
                if (this.target instanceof ServerPlayer && !this.target.m_6084_() && this.mob.m_9236_().m_45971_(Player.class, Wilted.TARGETING.m_26888_(entity -> entity != this.target), (LivingEntity)this.mob, this.target.m_20191_().m_82400_(this.mob.m_21133_(Attributes.f_22277_))).size() <= 0) {
                    this.mob.teleportTargetPos = Wilted.findSpawnablePosition(this.mob.m_20183_(), (ServerLevel)this.mob.m_9236_(), 48, 64, 32, 500, true);
                    if (this.mob.teleportTargetPos != null) {
                        this.mob.wantsToRevealCooldown = 100;
                        this.mob.wantsToReveal = false;
                        this.mob.willDisguiseOnNextTeleport = true;
                    }
                }
            }
        } else {
            this.canContinue = false;
        }
        ++this.useTicks;
    }

    public Vec3 pickUpPos() {
        Vec3 finalVec = Vec3.f_82478_;
        Vec3 targetVec1 = new Vec3(0.0, 3.0, 4.0);
        Vec3 targetVec2 = new Vec3(0.0, 4.5, 3.0);
        Vec3 targetVec3 = new Vec3(0.0, -0.5, 4.5);
        int ticks = this.useTicks % 40;
        if (ticks <= 10) {
            finalVec = targetVec1.m_165921_(targetVec2, (double)((float)ticks / 10.0f));
        } else if (ticks < 14) {
            finalVec = targetVec2;
        } else if (ticks <= 17) {
            finalVec = targetVec2.m_165921_(targetVec3, (double)((float)(ticks - 14) / 3.0f));
        } else if (ticks < 28) {
            finalVec = targetVec3;
        } else if (ticks <= 40) {
            finalVec = targetVec3.m_165921_(targetVec1, (double)((float)(ticks - 27) / 13.0f));
        }
        return PositionUtils.getOffsetPos((Entity)this.mob, finalVec.f_82479_, finalVec.f_82480_, finalVec.f_82481_, 0.0f, this.mob.f_20883_);
    }

    public void moveTargetToPickUpPos() {
        if (!(this.target instanceof ServerPlayer)) {
            Vec3 pos = this.pickUpPos();
            double distance = Math.max(PositionUtils.distanceTo((Entity)this.target, pos), 1.0f);
            this.target.m_20256_(new Vec3((pos.f_82479_ - this.target.m_20185_()) / distance, (pos.f_82480_ - this.target.m_20186_()) / distance, (pos.f_82481_ - this.target.m_20189_()) / distance));
        }
        this.target.m_183634_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.nextUseTime = this.mob.f_19797_ + 40;
        this.mob.m_20124_(Pose.STANDING);
    }
}

