/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.ai.goals.wilted;

import com.alexander.rootoffear.entities.LightExtinguisher;
import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.init.TagInit;
import com.alexander.rootoffear.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WiltedExtinguishLightsGoal
extends Goal {
    public Wilted mob;
    public int nextUseTime;
    public int useTicks;
    public List<BlockPos> targetPositions = Lists.newArrayList();

    public WiltedExtinguishLightsGoal(Wilted mob) {
        this.mob = mob;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        if (this.mob.f_19797_ > 10 && this.mob.f_19797_ >= this.nextUseTime) {
            this.findTargetPos();
            return !this.targetPositions.isEmpty();
        }
        return false;
    }

    public boolean m_8045_() {
        return this.useTicks > 0;
    }

    public void m_8056_() {
        this.useTicks = 20;
    }

    public void m_8037_() {
        if (this.useTicks == 10) {
            for (BlockPos pos : this.targetPositions) {
                if (this.mob.m_9236_().m_8055_(pos).m_204336_(TagInit.Blocks.DESTROYED_NOT_EXTINGUISHED)) {
                    this.mob.m_9236_().m_46961_(pos, false);
                    continue;
                }
                LightExtinguisher extinguisher = new LightExtinguisher(this.mob.m_9236_(), pos, (Entity)this.mob);
                this.mob.m_9236_().m_7967_((Entity)extinguisher);
                this.mob.m_9236_().m_7605_((Entity)extinguisher, (byte)7);
                extinguisher.m_216990_((SoundEvent)SoundEventInit.WILTED_EXTINGUISH.get());
            }
        }
        if (this.useTicks > 0) {
            --this.useTicks;
        }
    }

    public void findTargetPos() {
        Vec3 pos = this.mob.m_20182_().m_82520_(0.0, (double)(this.mob.m_20206_() / 2.0f), 0.0);
        int areaSize = 20;
        ArrayList validPositions = Lists.newArrayList();
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)(pos.f_82479_ - (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82480_ - (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82481_ - (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82479_ + (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82480_ + (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82481_ + (double)areaSize)))) {
            if (this.mob.m_9236_().m_7146_(blockpos) <= 6 || this.mob.m_9236_().m_45976_(LightExtinguisher.class, new AABB((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (double)(blockpos.m_123341_() + 1), (double)(blockpos.m_123342_() + 1), (double)(blockpos.m_123343_() + 1))).size() > 0 || !this.mob.m_9236_().m_6425_(blockpos).m_76178_() && !this.mob.m_9236_().m_6425_(blockpos).m_76170_()) continue;
            validPositions.add(new BlockPos(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()));
        }
        if (validPositions.size() > 0) {
            Collections.shuffle(validPositions);
            validPositions.sort(PositionUtils.distanceComparator(this.mob.m_20183_()));
            for (int i = 0; i < Math.max(1, validPositions.size() / 10) * Math.max(1, this.mob.m_9236_().m_45955_(TargetingConditions.m_148352_(), (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(30.0)).size()); ++i) {
                if (validPositions.size() <= i) continue;
                this.targetPositions.add((BlockPos)validPositions.get(i));
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.nextUseTime = this.mob.f_19797_ + 30;
        this.targetPositions.clear();
    }
}

