/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.ai.goals.wilted;

import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.events.CameraShakeEvents;
import com.alexander.rootoffear.init.ParticleTypeInit;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.particles.AdvancedParticleOption;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class WiltedBreakBlocksGoal
extends Goal {
    public Wilted mob;
    @Nullable
    public LivingEntity target;
    public int nextUseTime;
    public int useTicks;
    public int breakAmount;
    public AABB breakArea;
    public int lookedAwayTicks;
    public boolean canContinue;
    public boolean startedBreaking = false;

    public WiltedBreakBlocksGoal(Wilted mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.mob = mob;
        this.target = mob.m_5448_();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return ForgeEventFactory.getMobGriefingEvent((Level)this.mob.m_9236_(), (Entity)this.mob) && this.mob.chosenBonusBehaviours.contains((Object)this) && !this.mob.isDisguised() && this.mob.f_19797_ >= this.nextUseTime && MiscUtils.isEntityValid(this.target) && !this.mob.canPhaseThroughWalls() && !this.mob.m_142582_((Entity)this.target);
    }

    public boolean m_8045_() {
        return this.canContinue && this.lookedAwayTicks < 100 && (this.startedBreaking || MiscUtils.isEntityValid(this.target));
    }

    public void m_8056_() {
        this.useTicks = 0;
        this.breakAmount = 0;
        this.lookedAwayTicks = 0;
        this.startedBreaking = false;
        this.canContinue = true;
        this.mob.setSilentTimer(0);
    }

    public void m_8037_() {
        this.target = this.mob.m_5448_();
        if (!this.startedBreaking) {
            if (MiscUtils.isEntityValid(this.target)) {
                this.mob.targetMovementSpeed = 0.5;
                this.mob.m_21573_().m_5624_((Entity)this.target, 1.0);
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_146892_());
                if (this.mob.m_20270_((Entity)this.target) <= 15.0f) {
                    this.makeBreakArea();
                    int collidableBlocks = 0;
                    for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)this.breakArea.f_82288_), (int)Mth.m_14107_((double)this.breakArea.f_82289_), (int)Mth.m_14107_((double)this.breakArea.f_82290_), (int)Mth.m_14107_((double)this.breakArea.f_82291_), (int)Mth.m_14107_((double)this.breakArea.f_82292_), (int)Mth.m_14107_((double)this.breakArea.f_82293_))) {
                        if (!PositionUtils.isBlockCollidable(this.mob.m_9236_(), pos) || !(this.mob.m_9236_().m_8055_(pos).m_60734_().m_155943_() < 50.0f) || ++collidableBlocks < 16) continue;
                        this.startedBreaking = true;
                        this.mob.startAnimation(3);
                        this.mob.m_20124_(Pose.SPIN_ATTACK);
                        this.useTicks = 0;
                        break;
                    }
                }
            }
            if (this.useTicks >= 200 && !this.startedBreaking) {
                this.canContinue = false;
            }
        }
        if (this.startedBreaking) {
            this.mob.m_21573_().m_26573_();
            this.mob.m_20124_(Pose.SPIN_ATTACK);
            boolean flag = false;
            for (Player player : this.mob.m_9236_().m_6907_()) {
                if (!this.mob.isLookingAtMe(player) || !MiscUtils.inSurvivalMode((LivingEntity)player)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                this.mob.m_20124_(Pose.STANDING);
                ++this.lookedAwayTicks;
            }
            if (this.useTicks % 30 == 12 && this.mob.m_217003_(Pose.SPIN_ATTACK)) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.WILTED_ATTACK.get(), this.mob.m_6121_(), 1.0f);
            }
            if (this.useTicks % 30 == 3 && this.mob.m_217003_(Pose.SPIN_ATTACK)) {
                ++this.breakAmount;
                this.mob.m_5496_((SoundEvent)SoundEventInit.WILTED_LAND.get(), this.mob.m_6121_(), this.mob.m_6100_());
                this.mob.m_5496_(SoundEvents.f_12555_, this.mob.m_6121_(), this.mob.m_6100_());
                CameraShakeEvents.addCameraShake(this.mob.m_9236_(), 15, 2.0f, BlockPos.m_274446_((Position)this.breakArea.m_82399_()), 15);
                for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)this.breakArea.f_82288_), (int)Mth.m_14107_((double)this.breakArea.f_82289_), (int)Mth.m_14107_((double)this.breakArea.f_82290_), (int)Mth.m_14107_((double)this.breakArea.f_82291_), (int)Mth.m_14107_((double)this.breakArea.f_82292_), (int)Mth.m_14107_((double)this.breakArea.f_82293_))) {
                    if (!PositionUtils.isBlockCollidable(this.mob.m_9236_(), pos) || !(this.mob.m_9236_().m_8055_(pos).m_60734_().m_155943_() < 50.0f)) continue;
                    if (this.breakAmount >= 5) {
                        this.mob.m_9236_().m_46953_(pos, false, (Entity)this.mob);
                        continue;
                    }
                    ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.BLOCK_BREAKING, List.of(Double.valueOf((double)this.breakAmount * 2.0))), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.breakAmount >= 5) {
                    this.canContinue = false;
                }
            }
        }
        ++this.useTicks;
    }

    public void makeBreakArea() {
        AABB aabb;
        Vec2 rot = PositionUtils.rotationToFace(this.mob.m_146892_(), this.target.m_146892_());
        Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.0, (double)this.mob.m_20192_(), 3.0, rot.f_82470_, rot.f_82471_);
        this.breakArea = aabb = new AABB(pos.m_82520_(-2.5, -2.5, -2.5), pos.m_82520_(2.5, 2.5, 2.5)).m_165887_(this.mob.m_20186_() + 0.1);
    }

    public void m_8041_() {
        super.m_8041_();
        this.nextUseTime = this.mob.f_19797_ + MiscUtils.randomIntBetween(200, 600);
        this.mob.m_20124_(Pose.STANDING);
    }
}

