/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear;

import com.alexander.rootoffear.config.RoFClientConfig;
import com.alexander.rootoffear.config.RoFCommonConfig;
import com.alexander.rootoffear.entities.ShadowWilted;
import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.enums.RoFBedSleepingProblems;
import com.alexander.rootoffear.events.CapabilityEvents;
import com.alexander.rootoffear.init.EntityTypeInit;
import com.alexander.rootoffear.init.ItemInit;
import com.alexander.rootoffear.init.ParticleTypeInit;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.network.Messages;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="rootoffear")
public class TheRootOfFear {
    public static final List<ResourceKey<Level>> WILTED_SPAWNABLE_DIMENSIONS = Lists.newArrayList();
    public static final String MODID = "rootoffear";
    public static final Logger LOGGER = LogUtils.getLogger();

    public TheRootOfFear() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CapabilityEvents.setup();
        SoundEventInit.REGISTER.register(modEventBus);
        ParticleTypeInit.REGISTER.register(modEventBus);
        EntityTypeInit.REGISTER.register(modEventBus);
        ItemInit.REGISTER.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::addAttributes);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerCustomSpawnPlacements);
        RoFBedSleepingProblems.WILTED.T();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RoFCommonConfig.SPEC, "rootoffear/common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)RoFClientConfig.SPEC, "rootoffear/client.toml");
    }

    private void registerCustomSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)EntityTypeInit.WILTED.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wilted::checkWiltedSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    private void addAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityTypeInit.WILTED.get(), Wilted.createAttributes().m_22265_());
        event.put((EntityType)EntityTypeInit.SHADOW_WILTED.get(), ShadowWilted.createAttributes().m_22265_());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Messages.register();
        for (String string : (List)RoFCommonConfig.wilted_spawn_dimensions.get()) {
            WILTED_SPAWNABLE_DIMENSIONS.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(string)));
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.accept(ItemInit.WILTED_SPAWN_EGG);
        }
    }
}

