/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedFPRCurioModel;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class RageGloveItem
extends RelicItem
implements IRenderableCurio {
    public static final String TAG_STACKS = "stacks";
    public static final String TAG_TIME = "time";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("rage").maxLevel(10).stat(StatData.builder("incoming_damage").initialValue(0.05, 0.025).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.05).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat(StatData.builder("dealt_damage").initialValue(0.025, 0.075).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat(StatData.builder("duration").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder("phlebotomy").requiredLevel(5).maxLevel(10).stat(StatData.builder("heal").initialValue(1.0E-4, 2.5E-4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(MathUtils.round(value, 5) * 20.0, 5)).build()).stat(StatData.builder("movement_speed").initialValue(0.01, 0.025).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat(StatData.builder("attack_speed").initialValue(0.005, 0.01).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.05).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).build()).ability(AbilityData.builder("spurt").requiredLevel(10).maxLevel(10).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder("damage").initialValue(0.1, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).stat(StatData.builder("distance").initialValue(3.0, 8.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("cooldown").initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, -0.075).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 20, 100)).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        if (ability.equals("spurt")) {
            Vec3 target;
            int stacks = NBTUtils.getInt(stack, TAG_STACKS, 0);
            double maxDistance = this.getAbilityValue(stack, "spurt", "distance");
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * maxDistance, view.f_82480_ * maxDistance, view.f_82481_ * maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 current = player.m_20182_();
            int distance = (int)Math.ceil(current.m_82554_(target = ray.m_82450_()));
            if (distance <= 0) {
                return;
            }
            Vec3 motion = player.m_20184_().m_82549_(target.m_82546_(current).m_82541_());
            player.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
            if (!level.m_5776_()) {
                NetworkHandler.sendToClient(new PacketPlayerMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_), (ServerPlayer)player);
                this.setAbilityCooldown(stack, "spurt", (int)Math.round(this.getAbilityValue(stack, "spurt", "cooldown") * 20.0));
            }
            player.f_19789_ = 0.0f;
            level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.SPURT.get(), SoundSource.MASTER, 1.0f, 0.75f + random.m_188501_() * 0.5f);
            Vec3 start = current.m_82520_(0.0, 1.0, 0.0);
            Vec3 end = target.m_82520_(0.0, 1.0, 0.0);
            Vec3 delta = end.m_82546_(start);
            Vec3 dir = delta.m_82541_();
            for (int i = 0; i < distance * 20; ++i) {
                double progress = (double)i * delta.m_82553_() / (double)(distance * 20);
                level.m_7106_(ParticleUtils.constructSimpleSpark(new Color(255, 60 + random.m_188503_(60), 0), 0.2f + random.m_188501_() * 0.5f, 60 + random.m_188503_(60), 0.95f), start.f_82479_ + dir.f_82479_ * progress, start.f_82480_ + dir.f_82480_ * progress, start.f_82481_ + dir.f_82481_ * progress, 0.0, (double)(MathUtils.randomFloat(random) * 0.075f), 0.0);
            }
            ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
            for (int i = 0; i < distance; ++i) {
                double progress = (double)i * delta.m_82553_() / (double)distance;
                for (LivingEntity entity : level.m_45976_(LivingEntity.class, new AABB(new BlockPos((int)(start.f_82479_ + dir.f_82479_ * progress), (int)(start.f_82480_ + dir.f_82480_ * progress), (int)(start.f_82481_ + dir.f_82481_ * progress))).m_82377_(0.5, 1.0, 0.5))) {
                    if (entity.m_20149_().equals(player.m_20149_()) || entity.m_21224_()) continue;
                    targets.add(entity);
                }
            }
            if (!targets.isEmpty()) {
                EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22283_, 2.1474836E9f, AttributeModifier.Operation.MULTIPLY_BASE);
                EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22281_, (float)(this.getAbilityValue(stack, "spurt", "damage") * (double)stacks), AttributeModifier.Operation.ADDITION);
                for (LivingEntity entity : targets) {
                    if (entity.f_19802_ > 0 || EntityUtils.isAlliedTo((Entity)player, (Entity)entity)) continue;
                    player.m_5706_((Entity)entity);
                    this.spreadExperience((LivingEntity)player, stack, 1);
                    entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLEEDING.get(), 100, 0));
                    entity.m_7311_(100);
                }
                EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22281_, AttributeModifier.Operation.ADDITION);
                EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE);
            }
            NBTUtils.clearTag(stack, TAG_STACKS);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        int stacks;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.canUseAbility(stack, "phlebotomy")) {
            float percentage = 100.0f - player.m_21223_() / player.m_21233_() * 100.0f;
            if (player.m_21223_() < player.m_21233_()) {
                player.m_5634_((float)this.getAbilityValue(stack, "phlebotomy", "heal") * percentage);
            }
            EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22283_, (float)(this.getAbilityValue(stack, "phlebotomy", "attack_speed") * (double)percentage), AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22279_, (float)(this.getAbilityValue(stack, "phlebotomy", "movement_speed") * (double)percentage), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (this.canUseAbility(stack, "rage") && (stacks = NBTUtils.getInt(stack, TAG_STACKS, 0)) > 0) {
            int time = NBTUtils.getInt(stack, TAG_TIME, 0);
            if (time > 0) {
                NBTUtils.setInt(stack, TAG_TIME, --time);
            } else {
                NBTUtils.setInt(stack, TAG_STACKS, 0);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (stack.m_41720_() != newStack.m_41720_()) break block3;
            }
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        NBTUtils.clearTag(stack, TAG_STACKS);
        NBTUtils.clearTag(stack, TAG_TIME);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedFPRCurioModel(stack.m_41720_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        sidedModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_252880_(0.0f, 0.0f, -0.025f);
        sidedModel.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        mesh.m_171576_().m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-4.0f, 6.0f, -2.5f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 13).m_171480_().m_171488_(-1.0f, 6.0f, -2.5f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-4.5f, 8.0f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)-0.5f));
        mesh.m_171576_().m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 6.0f, -2.5f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 13).m_171488_(-2.0f, 6.0f, -2.5f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(3.5f, 8.0f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm", "left_arm"});
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Entity source = event.getSource().m_7640_();
            if (source instanceof Player) {
                Player player = (Player)source;
                if (!(event.getSource().m_7639_() instanceof Player)) {
                    return;
                }
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.RAGE_GLOVE.get());
                Item item = stack.m_41720_();
                if (!(item instanceof IRelicItem)) {
                    return;
                }
                IRelicItem relic = (IRelicItem)item;
                if (relic.canUseAbility(stack, "rage")) {
                    int stacks = NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS, 0);
                    NBTUtils.setInt(stack, RageGloveItem.TAG_STACKS, ++stacks);
                    NBTUtils.setInt(stack, RageGloveItem.TAG_TIME, (int)Math.round(relic.getAbilityValue(stack, "rage", "duration") * 20.0));
                    relic.spreadExperience((LivingEntity)player, stack, 1);
                    event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * ((double)stacks * relic.getAbilityValue(stack, "rage", "dealt_damage"))));
                }
            } else {
                LivingEntity stack = event.getEntity();
                if (stack instanceof Player) {
                    Player player = (Player)stack;
                    Item stacks = (stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.RAGE_GLOVE.get())).m_41720_();
                    if (!(stacks instanceof IRelicItem)) {
                        return;
                    }
                    IRelicItem relic = (IRelicItem)stacks;
                    if (relic.canUseAbility((ItemStack)stack, "rage")) {
                        int stacks2 = NBTUtils.getInt((ItemStack)stack, RageGloveItem.TAG_STACKS, 0);
                        if (stacks2 <= 0) {
                            return;
                        }
                        event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * ((double)stacks2 * relic.getAbilityValue((ItemStack)stack, "rage", "incoming_damage"))));
                    }
                }
            }
        }
    }
}

