/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

@Mod.EventBusSubscriber(modid="relics")
public class AquaWalkerItem
extends RelicItem
implements IRenderableCurio {
    public static final String TAG_DRENCH = "drench";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("walking").stat(StatData.builder("time").initialValue(30.0, 60.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-12024970).borderBottom(-15319760).textured(true).build()).build()).loot(LootData.builder().entry(LootCollections.AQUATIC).build()).build();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Player player;
        int drench;
        block5: {
            block4: {
                drench = NBTUtils.getInt(stack, TAG_DRENCH, 0);
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (player.f_19797_ % 20 == 0) break block5;
            }
            return;
        }
        if (drench > 0 && !player.m_20069_() && !player.m_9236_().m_6425_(player.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_)) {
            NBTUtils.setInt(stack, TAG_DRENCH, --drench);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedCurioModel(stack.m_41720_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        sidedModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_252880_(0.0f, 0.0f, -0.025f);
        sidedModel.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition rightLeg = mesh.m_171576_().m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-2.9f, 8.0f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.125f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        rightLeg.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(1.5f, 6.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        rightLeg.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.325f, 6.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftLeg = mesh.m_171576_().m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-2.9f, 8.0f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.125f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        leftLeg.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(1.5f, 6.5f, 4.4f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        leftLeg.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.325f, 6.5f, 4.2f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_leg", "left_leg"});
    }

    @SubscribeEvent
    public static void onFluidCollide(FluidCollisionEvent event) {
        Player player;
        int drench;
        IRelicItem relic;
        ItemStack stack;
        block7: {
            block6: {
                stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.AQUA_WALKER.get());
                Item item = stack.m_41720_();
                if (!(item instanceof IRelicItem)) {
                    return;
                }
                relic = (IRelicItem)item;
                drench = NBTUtils.getInt(stack, TAG_DRENCH, 0);
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (!((double)drench > relic.getAbilityValue(stack, "walking", "time")) && event.getFluid().m_205070_(FluidTags.f_13131_) && !player.m_6144_()) break block7;
            }
            return;
        }
        if (player.f_19797_ % 20 == 0) {
            NBTUtils.setInt(stack, TAG_DRENCH, ++drench);
            if (drench % 5 == 0) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }
        event.setCanceled(true);
    }
}

