/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.ability;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.general.AbstractBigCardWidget;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BigAbilityCardWidget
extends AbstractBigCardWidget {
    private final String ability;

    public BigAbilityCardWidget(int x, int y, IRelicScreenProvider provider, String ability) {
        super(x, y, provider);
        this.ability = ability;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = this.getProvider().getStack();
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.m_280168_();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.researching.ability.info.level").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE)).m_130946_(" " + relic.getAbilityPoints(stack, this.ability) + "/" + relic.getAbilityData(this.ability).getMaxLevel()), Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.relics.researching.ability.info.quality").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE)).m_130946_(" " + MathUtils.round((float)relic.getAbilityQuality(stack, this.ability) / 2.0f, 1) + "/" + relic.getMaxQuality() / 2), Component.m_237113_((String)" ")});
        if (Screen.m_96638_()) {
            entries.add(Component.m_237115_((String)"tooltip.relics.researching.ability.info.extra_info").m_130940_(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.m_237115_((String)"tooltip.relics.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.MC.f_91062_.m_92852_((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 400.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.m_280649_(this.MC.f_91062_, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.m_85849_();
    }
}

