/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hat;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.init.SoundRegistry;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class NightVisionGogglesItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"vision").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"amount").initialValue(0.1, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8061888).borderBottom(-16719810).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).entry(LootCollections.SCULK).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isAbilityTicking(stack, "vision")) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 10, 0, false, false));
            float percent = Math.abs(1.0f - (float)player.m_20193_().m_46803_(player.m_20183_()) / 15.0f);
            if (player.m_217043_().m_188501_() <= percent && player.f_19797_ % 60 == 0 && !(Math.abs(player.m_20184_().f_82479_) <= 0.01) && !(Math.abs(player.m_20184_().f_82481_) <= 0.01)) {
                this.spreadExperience((LivingEntity)player, stack, 1);
            }
        } else if (this.isNightVision(player.m_21220_())) {
            player.m_21195_(MobEffects.f_19611_);
        }
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("vision") && player.m_20193_().f_46443_ && stage == CastStage.START) {
            player.m_5496_((SoundEvent)SoundRegistry.NIGHT_VISION_TOGGLE.get(), 1.0f, 0.75f + player.m_217043_().m_188501_() * 0.5f);
        }
    }

    public boolean isNightVision(Collection<MobEffectInstance> activeEffects) {
        return !activeEffects.isEmpty() && activeEffects.stream().anyMatch(entity -> entity.m_19544_() == MobEffects.f_19611_ && entity.m_19557_() <= 10);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class NightVisionGogglesEvent {
        @SubscribeEvent
        public static void onFogRender(ViewportEvent.RenderFog event) {
            NightVisionGogglesItem relic;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.NIGHT_VISION_GOGGLES.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof NightVisionGogglesItem) || !(relic = (NightVisionGogglesItem)item).isAbilityTicking(stack, "vision") || !player.m_21023_(MobEffects.f_19610_) && !player.m_21023_(MobEffects.f_216964_)) {
                return;
            }
            double statValue = relic.getAbilityValue(stack, "vision", "amount") * (double)(player.m_21023_(MobEffects.f_19610_) ? 9 : 1);
            event.scaleFarPlaneDistance((float)((double)event.getFarPlaneDistance() * statValue));
            event.setCanceled(true);
        }
    }
}

