/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hat;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CowboyHatItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"cowboy").stat(StatData.builder((String)"speed").initialValue(0.2, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).ability(AbilityData.builder((String)"overlord").active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(5).stat(StatData.builder((String)"time").initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-11065324).borderBottom(-12110298).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).build()).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Mob beingMounted;
        Player player;
        block13: {
            block12: {
                Entity entity2;
                if (!(entity instanceof Player) || !((entity2 = (player = (Player)entity).m_20201_()) instanceof Mob)) break block12;
                beingMounted = (Mob)entity2;
                if (this.getToggled(stack) && this.checkMob((Entity)player, EnderDragon.class, WitherBoss.class, Warden.class, ElderGuardian.class)) break block13;
            }
            return;
        }
        if (this.isAbilityOnCooldown(stack, "overlord") || !this.canPlayerUseActiveAbility(player, stack, "overlord")) {
            player.m_8127_();
        } else {
            RandomSource random = player.m_217043_();
            Level level = player.m_20193_();
            if ((double)this.getTime(stack) >= this.getAbilityValue(stack, "overlord", "time") * 20.0) {
                player.m_8127_();
                player.m_5496_(SoundEvents.f_12641_, 1.0f, 0.9f + player.m_217043_().m_188501_() * 0.2f);
                this.setTime(stack, 0);
                for (int i = 0; i < 50; ++i) {
                    level.m_7106_(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.m_188503_(106), 50 + random.m_188503_(100), 50 + random.m_188503_(100)), (float)0.5f, (int)60, (float)0.95f), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), (random.m_188500_() - 0.5) * 3.0, random.m_188500_() * 1.5, (random.m_188500_() - 0.5) * 3.0);
                }
            } else {
                if (level.m_5776_() && player instanceof LocalPlayer) {
                    LocalPlayer localPlayer = (LocalPlayer)player;
                    if (localPlayer.f_108618_.f_108572_ && beingMounted.m_20096_() && !this.isWaterOrFlyingMob(beingMounted)) {
                        beingMounted.m_246865_(new Vec3(0.0, 0.8, 0.0));
                    }
                }
                Vec3 movement = beingMounted.m_20184_();
                if ((movement.f_82479_ != 0.0 || movement.f_82481_ != 0.0) && random.m_188501_() <= 0.25f && player.f_19797_ % 20 == 0) {
                    this.spreadExperience((LivingEntity)player, stack, 1);
                }
                if (this.canPlayerUseActiveAbility(player, stack, "cowboy")) {
                    this.changeAttributes(beingMounted, stack, true, Attributes.f_22279_, Attributes.f_22288_);
                }
                this.addTime(stack, 1);
            }
        }
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (player.m_20193_().m_5776_() || !ability.equals("overlord")) {
            return;
        }
        double range = player.m_7500_() ? 5.0 : 3.0;
        EntityHitResult result = EntityUtils.rayTraceEntity((Entity)player, entity -> entity instanceof Mob && this.checkMob((Entity)entity, (Class<? extends Mob>)EnderDragon.class, (Class<? extends Mob>)WitherBoss.class, (Class<? extends Mob>)Warden.class, (Class<? extends Mob>)ElderGuardian.class) && !player.m_20159_(), (double)range);
        if (result == null) {
            return;
        }
        this.setToggled(stack, true);
        this.spreadExperience((LivingEntity)player, stack, 1);
        player.m_20329_(result.m_82443_());
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        Player player;
        Entity entity2;
        if (!(entity instanceof Player) || !((entity2 = (player = (Player)entity).m_20201_()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity2;
        this.changeAttributes(mob, stack, false, Attributes.f_22279_, Attributes.f_22288_);
        if (!(player.m_20202_() instanceof Mob)) {
            player.m_8127_();
        }
    }

    @SafeVarargs
    public final void changeAttributes(Mob beingMounted, ItemStack stack, boolean flag, Attribute ... attributes) {
        for (Attribute attribute : attributes) {
            if (flag) {
                EntityUtils.applyAttribute((LivingEntity)beingMounted, (ItemStack)stack, (Attribute)attribute, (float)((float)this.getAbilityValue(stack, "cowboy", "speed")), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
                continue;
            }
            EntityUtils.removeAttribute((LivingEntity)beingMounted, (ItemStack)stack, (Attribute)attribute, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        }
    }

    @SafeVarargs
    private boolean checkMob(Entity entity, Class<? extends Mob> ... mobClasses) {
        for (Class<? extends Mob> mobClass : mobClasses) {
            if (!mobClass.isInstance(entity)) continue;
            return false;
        }
        return true;
    }

    public boolean isWaterOrFlyingMob(Mob mounted) {
        return mounted instanceof FlyingAnimal || mounted instanceof FlyingMob || mounted instanceof WaterAnimal || mounted instanceof AmbientCreature;
    }

    public void addTime(ItemStack stack, int val) {
        this.setTime(stack, this.getTime(stack) + val);
    }

    public int getTime(ItemStack stack) {
        return NBTUtils.getInt((ItemStack)stack, (String)"time", (int)0);
    }

    public void setTime(ItemStack stack, int val) {
        NBTUtils.setInt((ItemStack)stack, (String)"time", (int)Math.max(val, 0));
    }

    public void setToggled(ItemStack stack, boolean val) {
        NBTUtils.setBoolean((ItemStack)stack, (String)"toggled", (boolean)val);
    }

    public boolean getToggled(ItemStack stack) {
        return NBTUtils.getBoolean((ItemStack)stack, (String)"toggled", (boolean)false);
    }

    @Mod.EventBusSubscriber
    public static class CowboyEvent {
        @SubscribeEvent
        public static void onEntityMount(EntityMountEvent event) {
            Mob mount;
            CowboyHatItem relic;
            ItemStack stack;
            block5: {
                block4: {
                    Item item;
                    Entity entity = event.getEntity();
                    if (!(entity instanceof Player)) {
                        return;
                    }
                    Player player = (Player)entity;
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.COWBOY_HAT.get()));
                    if (player.m_20193_().m_5776_() || !((item = stack.m_41720_()) instanceof CowboyHatItem)) break block4;
                    relic = (CowboyHatItem)item;
                    if (!event.isDismounting() || !((item = event.getEntityBeingMounted()) instanceof Mob)) break block4;
                    mount = (Mob)item;
                    if (relic.getToggled(stack)) break block5;
                }
                return;
            }
            relic.addAbilityCooldown(stack, "overlord", 600);
            relic.setTime(stack, 0);
            relic.setToggled(stack, false);
            relic.changeAttributes(mount, stack, false, Attributes.f_22279_, Attributes.f_22288_);
        }
    }
}

