/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.protectionpixel.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.protectionpixel.ProtectionPixelMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ProtectionPixelModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ProtectionPixelMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ProtectionPixelMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.active = message.data.active;
                    variables.x = message.data.x;
                    variables.y = message.data.y;
                    variables.z = message.data.z;
                    variables.wingnbt = message.data.wingnbt;
                    variables.grenade = message.data.grenade;
                    variables.hellsnake = message.data.hellsnake;
                    variables.platecount = message.data.platecount;
                    variables.wingclose = message.data.wingclose;
                    variables.ppweight = message.data.ppweight;
                    variables.ppweightlevel = message.data.ppweightlevel;
                    variables.pphead = message.data.pphead;
                    variables.ppchest = message.data.ppchest;
                    variables.ppleg = message.data.ppleg;
                    variables.ppfoot = message.data.ppfoot;
                    variables.hookx = message.data.hookx;
                    variables.hooky = message.data.hooky;
                    variables.hookz = message.data.hookz;
                    variables.hookline = message.data.hookline;
                    variables.hookhit = message.data.hookhit;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean active = false;
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;
        public ItemStack wingnbt = ItemStack.f_41583_;
        public boolean grenade = false;
        public double hellsnake = 0.0;
        public double platecount = 0.0;
        public double wingclose = 0.0;
        public double ppweight = 0.0;
        public double ppweightlevel = 0.0;
        public ItemStack pphead = ItemStack.f_41583_;
        public ItemStack ppchest = ItemStack.f_41583_;
        public ItemStack ppleg = ItemStack.f_41583_;
        public ItemStack ppfoot = ItemStack.f_41583_;
        public double hookx = 0.0;
        public double hooky = 0.0;
        public double hookz = 0.0;
        public boolean hookline = false;
        public boolean hookhit = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ProtectionPixelMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("active", this.active);
            nbt.m_128347_("x", this.x);
            nbt.m_128347_("y", this.y);
            nbt.m_128347_("z", this.z);
            nbt.m_128365_("wingnbt", (Tag)this.wingnbt.m_41739_(new CompoundTag()));
            nbt.m_128379_("grenade", this.grenade);
            nbt.m_128347_("hellsnake", this.hellsnake);
            nbt.m_128347_("platecount", this.platecount);
            nbt.m_128347_("wingclose", this.wingclose);
            nbt.m_128347_("ppweight", this.ppweight);
            nbt.m_128347_("ppweightlevel", this.ppweightlevel);
            nbt.m_128365_("pphead", (Tag)this.pphead.m_41739_(new CompoundTag()));
            nbt.m_128365_("ppchest", (Tag)this.ppchest.m_41739_(new CompoundTag()));
            nbt.m_128365_("ppleg", (Tag)this.ppleg.m_41739_(new CompoundTag()));
            nbt.m_128365_("ppfoot", (Tag)this.ppfoot.m_41739_(new CompoundTag()));
            nbt.m_128347_("hookx", this.hookx);
            nbt.m_128347_("hooky", this.hooky);
            nbt.m_128347_("hookz", this.hookz);
            nbt.m_128379_("hookline", this.hookline);
            nbt.m_128379_("hookhit", this.hookhit);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.active = nbt.m_128471_("active");
            this.x = nbt.m_128459_("x");
            this.y = nbt.m_128459_("y");
            this.z = nbt.m_128459_("z");
            this.wingnbt = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("wingnbt"));
            this.grenade = nbt.m_128471_("grenade");
            this.hellsnake = nbt.m_128459_("hellsnake");
            this.platecount = nbt.m_128459_("platecount");
            this.wingclose = nbt.m_128459_("wingclose");
            this.ppweight = nbt.m_128459_("ppweight");
            this.ppweightlevel = nbt.m_128459_("ppweightlevel");
            this.pphead = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("pphead"));
            this.ppchest = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ppchest"));
            this.ppleg = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ppleg"));
            this.ppfoot = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ppfoot"));
            this.hookx = nbt.m_128459_("hookx");
            this.hooky = nbt.m_128459_("hooky");
            this.hookz = nbt.m_128459_("hookz");
            this.hookline = nbt.m_128471_("hookline");
            this.hookhit = nbt.m_128471_("hookhit");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("protection_pixel", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.pphead = original.pphead;
            clone.ppchest = original.ppchest;
            clone.ppleg = original.ppleg;
            clone.ppfoot = original.ppfoot;
            if (!event.isWasDeath()) {
                clone.active = original.active;
                clone.x = original.x;
                clone.y = original.y;
                clone.z = original.z;
                clone.wingnbt = original.wingnbt;
                clone.grenade = original.grenade;
                clone.hellsnake = original.hellsnake;
                clone.platecount = original.platecount;
                clone.wingclose = original.wingclose;
                clone.ppweight = original.ppweight;
                clone.ppweightlevel = original.ppweightlevel;
                clone.hookx = original.hookx;
                clone.hooky = original.hooky;
                clone.hookz = original.hookz;
                clone.hookline = original.hookline;
                clone.hookhit = original.hookhit;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }
    }
}

