/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp.bothbound;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.PacketUdpHandler;

public class PingPacket
implements Packet<PacketUdpHandler> {
    private long time = System.currentTimeMillis();
    private String serverIp;
    private int serverPort;

    public PingPacket(@NotNull String serverIp, int serverPort) {
        this.serverIp = serverIp;
        this.serverPort = serverPort;
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.time = in.readLong();
        try {
            this.serverIp = in.readUTF();
            this.serverPort = in.readShort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeLong(this.time);
        if (this.serverIp != null && this.serverPort > 0) {
            out.writeUTF(this.serverIp);
            out.writeShort(this.serverPort);
        }
    }

    @Override
    public void handle(PacketUdpHandler handler) {
        handler.handle(this);
    }

    public String toString() {
        return "PingPacket(time=" + this.getTime() + ", serverIp=" + this.getServerIp() + ", serverPort=" + this.getServerPort() + ")";
    }

    public PingPacket() {
    }

    public long getTime() {
        return this.time;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }
}

