/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.language.LanguageUtil;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McLiteralText;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.style.McTextStyle;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.client.config.hotkey.HotkeyConfigEntry;
import su.plo.voice.client.gui.settings.tab.AbstractHotKeysTabWidget;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class HotKeyWidget
extends Button
implements UpdatableWidget {
    private final AbstractHotKeysTabWidget parent;
    private final HotkeyConfigEntry entry;
    private final List<Hotkey.Key> pressedKeys = new ArrayList<Hotkey.Key>();

    public HotKeyWidget(@NotNull AbstractHotKeysTabWidget parent, @NotNull HotkeyConfigEntry entry, int x, int y, int width, int height) {
        super(x, y, width, height, McTextComponent.empty(), NO_ACTION, NO_TOOLTIP);
        this.parent = parent;
        this.entry = entry;
        this.updateValue();
    }

    @Override
    public void updateValue() {
        McLiteralText text = McTextComponent.literal("");
        if (((Hotkey)this.entry.value()).getKeys().size() == 0) {
            text.append(McTextComponent.translatable("gui.none", new Object[0]));
        } else {
            this.formatKeys(text, ((Hotkey)this.entry.value()).getKeys());
        }
        if (this.isActive()) {
            if (this.pressedKeys.size() > 0) {
                text = McTextComponent.literal("");
                List<Hotkey.Key> sorted2 = this.pressedKeys.stream().sorted(Comparator.comparingInt(key -> key.getType().ordinal())).collect(Collectors.toList());
                this.formatKeys(text, sorted2);
            }
            this.setText(McTextComponent.literal("> ").withStyle(McTextStyle.YELLOW).append(text.withStyle(McTextStyle.YELLOW)).append(McTextComponent.literal(" <").withStyle(McTextStyle.YELLOW)));
        } else {
            this.setText(text);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isActive() && (button != 0 || this.pressedKeys.size() != 0) && this.pressedKeys.stream().anyMatch(key -> key.getType() == Hotkey.Type.MOUSE && key.getCode() == button)) {
            this.keysReleased();
            this.updateValue();
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isActive()) {
            if (this.pressedKeys.size() < 3) {
                this.pressedKeys.add(Hotkey.Type.MOUSE.getOrCreate(button));
            }
            this.updateValue();
            return true;
        }
        if (this.isClicked(mouseX, mouseY) && this.isValidClickButton(button)) {
            this.parent.setFocusedHotKey(this);
            this.updateValue();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int modifiers) {
        if (this.isActive()) {
            if (keyCode == 256) {
                if (this.pressedKeys.size() > 0) {
                    this.keysReleased();
                } else {
                    this.parent.setFocusedHotKey(null);
                    ((Hotkey)this.entry.value()).getKeys().clear();
                    this.updateValue();
                }
                return true;
            }
            Hotkey.Key key = Hotkey.Type.KEYSYM.getOrCreate(keyCode);
            if (this.pressedKeys.size() < 3 && !this.pressedKeys.contains(key)) {
                this.pressedKeys.add(key);
            }
            this.updateValue();
            return true;
        }
        return super.keyPressed(keyCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, char typedChar, int modifiers) {
        if (this.isActive() && this.pressedKeys.stream().anyMatch(key -> key.getType() == Hotkey.Type.KEYSYM && key.getCode() == keyCode)) {
            this.keysReleased();
            this.updateValue();
            return true;
        }
        return super.keyReleased(keyCode, typedChar, modifiers);
    }

    @Override
    protected void renderText(@NotNull GuiRenderContext context, int mouseX, int mouseY) {
        Color textColor = Colors.withAlpha(this.active ? Colors.WHITE : Colors.GRAY, this.alpha);
        if (Objects.equals(this.parent.getFocusedHotKey(), this)) {
            context.drawCenteredString(this.getText(), this.x + this.width / 2, this.y + this.height / 2 - RenderUtil.getFontHeight() / 2, textColor);
        } else {
            context.drawCenteredOrderedString(this.getText(), this.width - 16, this.x + this.width / 2, this.y + this.height / 2 - RenderUtil.getFontHeight() / 2, textColor);
        }
    }

    @Override
    public void renderToolTip(@NotNull GuiRenderContext context, int mouseX, int mouseY) {
        int width;
        if (!Objects.equals(this.parent.getFocusedHotKey(), this) && (width = RenderUtil.getTextWidth(this.getText())) > this.width - 16) {
            this.parent.setTooltip(this.getText());
        }
        super.renderToolTip(context, mouseX, mouseY);
    }

    @Override
    public boolean isActive() {
        return Objects.equals(this.parent.getFocusedHotKey(), this);
    }

    public void keysReleased() {
        ((Hotkey)this.entry.value()).setKeys((Set<Hotkey.Key>)ImmutableSet.copyOf(this.pressedKeys));
        this.pressedKeys.clear();
        this.parent.setFocusedHotKey(null);
    }

    private void formatKeys(McTextComponent text, Collection<Hotkey.Key> keys2) {
        for (Hotkey.Key key : keys2) {
            text.append(LanguageUtil.getKeyDisplayName(key));
            text.append(McTextComponent.literal(" + "));
        }
        text.getSiblings().remove(text.getSiblings().size() - 1);
    }
}

