/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.logging.McLoggerFactory;
import su.plo.slib.mod.logging.Log4jLogger;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.device.AlInputDeviceFactory;
import su.plo.voice.client.audio.device.AlOutputDeviceFactory;
import su.plo.voice.client.audio.device.JavaxInputDeviceFactory;
import su.plo.voice.client.connection.ModClientChannelHandler;
import su.plo.voice.client.event.key.KeyPressedEvent;
import su.plo.voice.client.gui.settings.VoiceScreens;
import su.plo.voice.client.render.ModHudRenderer;
import su.plo.voice.client.render.ModLevelRenderer;
import su.plo.voice.util.version.ModrinthLoader;

public final class ModVoiceClient
extends BaseVoiceClient {
    public static ModVoiceClient INSTANCE;
    private final String modId = "plasmovoice";
    public static final KeyMapping MENU_KEY;
    private final ModHudRenderer hudRenderer;
    private final ModLevelRenderer levelRenderer;
    private final ModClientChannelHandler handler = new ModClientChannelHandler(this);

    public ModVoiceClient() {
        super(ModrinthLoader.FORGE);
        McLoggerFactory.supplier = Log4jLogger::new;
        DeviceFactoryManager factoryManager = this.getDeviceFactoryManager();
        factoryManager.registerDeviceFactory(new AlOutputDeviceFactory(this));
        factoryManager.registerDeviceFactory(new AlInputDeviceFactory(this));
        this.getDeviceFactoryManager().registerDeviceFactory(new JavaxInputDeviceFactory(this));
        this.hudRenderer = new ModHudRenderer();
        this.levelRenderer = new ModLevelRenderer(this);
        INSTANCE = this;
        RenderUtil.getTextConverter().setLanguageSupplier(this.createLanguageSupplier());
    }

    @Override
    protected void onServerDisconnect() {
        super.onServerDisconnect();
        this.handler.close();
    }

    @EventSubscribe
    public void onKeyPressed(@NotNull KeyPressedEvent event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (MENU_KEY.m_90859_()) {
            VoiceScreens.INSTANCE.openSettings(this);
        }
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return new File("config/plasmovoice");
    }

    @Override
    public Optional<ServerConnection> getServerConnection() {
        return this.handler.getConnection();
    }

    public void onInitialize(EventNetworkChannel channel) {
        channel.addListener(this.handler::receive);
        super.onInitialize();
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGuiOverlayEvent.Post event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.CHAT_PANEL.id())) {
            return;
        }
        this.hudRenderer.render(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        this.onServerDisconnect();
    }

    @SubscribeEvent
    public void onWorldRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        this.levelRenderer.render(Minecraft.m_91087_().f_91073_, event.getPoseStack(), event.getCamera(), event.getPartialTick());
    }

    public ModHudRenderer getHudRenderer() {
        return this.hudRenderer;
    }

    public ModLevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    static {
        MENU_KEY = new KeyMapping("key.plasmovoice.settings", InputConstants.Type.KEYSYM, 86, "Plasmo Voice");
    }

    @Mod.EventBusSubscriber(modid="plasmovoice", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onKeyMappingsRegister(RegisterKeyMappingsEvent event) {
            event.register(MENU_KEY);
        }
    }
}

