/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.mod.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.McLib;
import su.plo.slib.api.event.command.McCommandsRegisterEvent;
import su.plo.slib.api.event.player.McPlayerJoinEvent;
import su.plo.slib.api.event.player.McPlayerQuitEvent;
import su.plo.slib.api.server.event.command.McServerCommandsRegisterEvent;
import su.plo.slib.mod.ModServerLib;
import su.plo.slib.mod.command.ModCommandManager;
import su.plo.slib.mod.event.server.ServerStartedEvent;
import su.plo.slib.mod.event.server.ServerStoppingEvent;
import su.plo.slib.mod.extension.ServerPlayerKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.JvmStatic;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u001d\u0010\u001c\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\"\u0010!\u00a8\u0006$"}, d2={"Lsu/plo/slib/mod/event/ModServerEvents;", "", "<init>", "()V", "Lnet/minecraftforge/event/server/ServerStartedEvent;", "event", "", "onServerStart", "(Lnet/minecraftforge/event/server/ServerStartedEvent;)V", "Lnet/minecraftforge/event/server/ServerStoppingEvent;", "(Lnet/minecraftforge/event/server/ServerStoppingEvent;)V", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "onPlayerJoin", "(Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;)V", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedOutEvent;", "onPlayerQuit", "(Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedOutEvent;)V", "Lnet/minecraftforge/event/RegisterCommandsEvent;", "onCommandRegister", "(Lnet/minecraftforge/event/RegisterCommandsEvent;)V", "Lnet/minecraft/server/MinecraftServer;", "minecraftServer", "fireServerStarted", "(Lnet/minecraft/server/MinecraftServer;)V", "fireServerStopping", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "fireRegisterCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "firePlayerJoin", "(Lnet/minecraft/server/level/ServerPlayer;)V", "firePlayerQuit", "Companion", "slib-forge-1.20.1"})
public final class ModServerEvents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static ModServerEvents instance;

    private ModServerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public final void onServerStart(@NotNull net.minecraftforge.event.server.ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue(minecraftServer, "getServer(...)");
        this.fireServerStarted(minecraftServer);
    }

    @SubscribeEvent
    public final void onServerStart(@NotNull net.minecraftforge.event.server.ServerStoppingEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue(minecraftServer, "getServer(...)");
        this.fireServerStopping(minecraftServer);
    }

    @SubscribeEvent
    public final void onPlayerJoin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getEntity();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        this.firePlayerJoin(player2);
    }

    @SubscribeEvent
    public final void onPlayerQuit(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getEntity();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        this.firePlayerQuit(player2);
    }

    @SubscribeEvent
    public final void onCommandRegister(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue(commandDispatcher, "getDispatcher(...)");
        this.fireRegisterCommands((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    private final void fireServerStarted(MinecraftServer minecraftServer) {
        ModServerLib.INSTANCE.onInitialize(minecraftServer);
        ((ServerStartedEvent.Callback)ServerStartedEvent.INSTANCE.getInvoker()).onServerStarted(minecraftServer);
    }

    private final void fireServerStopping(MinecraftServer minecraftServer) {
        ((ServerStoppingEvent.Callback)ServerStoppingEvent.INSTANCE.getInvoker()).onServerStopping(minecraftServer);
    }

    private final void fireRegisterCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        ModServerLib minecraftServer = ModServerLib.INSTANCE;
        ModCommandManager commandManager = minecraftServer.getCommandManager();
        commandManager.clear();
        ((McCommandsRegisterEvent.Callback)McServerCommandsRegisterEvent.INSTANCE.getInvoker()).onCommandsRegister(commandManager, (McLib)minecraftServer);
        commandManager.registerCommands(dispatcher);
    }

    private final void firePlayerJoin(ServerPlayer player) {
        ((McPlayerJoinEvent.Callback)McPlayerJoinEvent.INSTANCE.getInvoker()).onPlayerJoin(ServerPlayerKt.toMcServerPlayer$default(player, null, 1, null));
    }

    private final void firePlayerQuit(ServerPlayer player) {
        ((McPlayerQuitEvent.Callback)McPlayerQuitEvent.INSTANCE.getInvoker()).onPlayerQuit(ServerPlayerKt.toMcServerPlayer$default(player, null, 1, null));
    }

    @JvmStatic
    public static final void initialize() {
        Companion.initialize();
    }

    public /* synthetic */ ModServerEvents(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsu/plo/slib/mod/event/ModServerEvents$Companion;", "", "<init>", "()V", "", "initialize", "Lsu/plo/slib/mod/event/ModServerEvents;", "instance", "Lsu/plo/slib/mod/event/ModServerEvents;", "slib-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void initialize() {
            if (instance == null) {
                instance = new ModServerEvents(null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

