/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McGameProfile;

public final class ModPlayerSkins {
    private static final Cache<UUID, Supplier<ResourceLocation>> SKINS = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @NotNull ScheduledExecutorService backgroundExecutor) {
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(playerId);
        if (playerInfo != null) {
            return;
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return;
        }
        backgroundExecutor.execute(() -> {
            GameProfile profile = Minecraft.m_91087_().m_91108_().fillProfileProperties(new GameProfile(playerId, nick), false);
            SKINS.put((Object)profile.getId(), ModPlayerSkins.getInsecureSkinLocation(profile));
        });
    }

    public static synchronized void loadSkin(@NotNull McGameProfile gameProfile) {
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        Supplier<ResourceLocation> skinLocation = (Supplier<ResourceLocation>)SKINS.getIfPresent((Object)gameProfile.getId());
        if (skinLocation != null) {
            return;
        }
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile.getProperties().forEach(property -> profile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature())));
        skinLocation = ModPlayerSkins.getInsecureSkinLocation(profile);
        SKINS.put((Object)gameProfile.getId(), skinLocation);
    }

    private static Supplier<ResourceLocation> getInsecureSkinLocation(GameProfile gameProfile) {
        MinecraftProfileTexture minecraftProfileTexture = (MinecraftProfileTexture)Minecraft.m_91087_().m_91109_().m_118815_(gameProfile).get(MinecraftProfileTexture.Type.SKIN);
        return minecraftProfileTexture != null ? () -> Minecraft.m_91087_().m_91109_().m_118825_(minecraftProfileTexture, MinecraftProfileTexture.Type.SKIN) : () -> ModPlayerSkins.getDefaultSkin(gameProfile.getId());
    }

    @NotNull
    public static synchronized ResourceLocation getSkin(@NotNull UUID playerId, @NotNull String nick) {
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(playerId);
        if (playerInfo != null) {
            return playerInfo.m_105337_();
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return (ResourceLocation)skinLocation.get();
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static ResourceLocation getDefaultSkin(@NotNull UUID playerId) {
        return DefaultPlayerSkin.m_118627_((UUID)playerId);
    }

    private ModPlayerSkins() {
    }
}

