/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.foundation.util.Vec3iUtils;
import com.simibubi.create.content.schematics.SchematicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.createmod.catnip.levelWrappers.SchematicChunkSource;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.math.BBHelper;
import net.createmod.ponder.Ponder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;

public class PatternSchematicLevel
extends SchematicLevel {
    public Vec3i cloneScaleMin;
    public Vec3i cloneScaleMax;
    public Vec3i cloneOffset;
    public BoundingBox sourceBounds;

    public PatternSchematicLevel(BlockPos anchor, Level original) {
        super(anchor, original);
        this.setChunkSource((ChunkSource)new SchematicChunkSource((Level)this));
        this.blocks = new HashMap();
        this.blockEntities = new HashMap();
        this.bounds = new BoundingBox(BlockPos.f_121853_);
        this.anchor = anchor;
        this.entities = new ArrayList();
        this.renderedBlockEntities = new ArrayList();
    }

    public void putExtraData(ItemStack blueprint, StructureTemplate template) {
        CompoundTag tag = blueprint.m_41783_();
        assert (tag != null);
        this.cloneScaleMin = Vec3iUtils.getVec3i("CloneScaleMin", tag);
        this.cloneScaleMax = Vec3iUtils.getVec3i("CloneScaleMax", tag);
        this.cloneOffset = Vec3iUtils.getVec3i("CloneOffset", tag);
        this.sourceBounds = template.m_74633_(SchematicItem.getSettings((ItemStack)blueprint), this.anchor);
    }

    public boolean m_7967_(Entity entityIn) {
        return this.applyToClones(clonePos -> {
            Entity newEntity = this.cloneEntity(entityIn);
            newEntity.m_146884_(this.applyCloneToRealLoc(newEntity.m_20182_(), (Vec3i)clonePos));
            return super.m_7967_(newEntity);
        });
    }

    protected Entity cloneEntity(Entity source) {
        CompoundTag tag = new CompoundTag();
        source.m_20223_(tag);
        Entity newEntity = (Entity)EntityType.m_20642_((CompoundTag)tag, (Level)this.level).orElseThrow();
        newEntity.m_20084_(UUID.randomUUID());
        return newEntity;
    }

    protected boolean applyToClones(Function<Vec3i, Boolean> function) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.forEachClone(clonePos -> {
            if (((Boolean)function.apply((Vec3i)clonePos)).booleanValue()) {
                result.set(true);
            }
        });
        return result.get();
    }

    protected void forEachClone(Consumer<Vec3i> consumer) {
        for (int x = this.cloneScaleMin.m_123341_(); x <= this.cloneScaleMax.m_123341_(); ++x) {
            for (int y = this.cloneScaleMin.m_123342_(); y <= this.cloneScaleMax.m_123342_(); ++y) {
                for (int z = this.cloneScaleMin.m_123343_(); z <= this.cloneScaleMax.m_123343_(); ++z) {
                    consumer.accept(new Vec3i(x, y, z));
                }
            }
        }
    }

    public BoundingBox genBounds(BoundingBox originalBounds, StructurePlaceSettings placeSettings) {
        return originalBounds;
    }

    protected Vec3 applyCloneToRealLoc(Vec3 local, Vec3i clone) {
        return local.m_82549_(Vec3.m_82528_((Vec3i)Vec3iUtils.multiplyVec3i(clone, this.sourceBounds.m_71053_().m_7918_(1, 1, 1))));
    }

    public Set<BlockPos> getAllPositions() {
        return this.blocks.keySet();
    }

    public List<Entity> getEntityList() {
        return this.entities;
    }

    public BlockEntity m_7702_(BlockPos pos) {
        if (this.m_151570_(pos)) {
            return null;
        }
        if (this.blockEntities.containsKey(pos)) {
            return (BlockEntity)this.blockEntities.get(pos);
        }
        if (!this.blocks.containsKey(pos.m_121996_((Vec3i)this.anchor))) {
            return null;
        }
        BlockState blockState = this.m_8055_(pos);
        if (blockState.m_155947_()) {
            try {
                BlockEntity blockEntity = ((EntityBlock)blockState.m_60734_()).m_142194_(pos, blockState);
                if (blockEntity != null) {
                    this.onBEadded(blockEntity, pos);
                    this.blockEntities.put(pos, blockEntity);
                    this.renderedBlockEntities.add(blockEntity);
                }
                return blockEntity;
            }
            catch (Exception e) {
                Ponder.LOGGER.debug("Could not create BlockEntity of block " + blockState, (Throwable)e);
            }
        }
        return null;
    }

    protected void onBEadded(BlockEntity blockEntity, BlockPos pos) {
        blockEntity.m_142339_((Level)this);
    }

    public BlockState m_8055_(BlockPos globalPos) {
        BlockPos pos = globalPos.m_121996_((Vec3i)this.anchor);
        if (pos.m_123342_() - this.bounds.m_162396_() == -1 && !this.renderMode) {
            return Blocks.f_50493_.m_49966_();
        }
        if (this.getBounds().m_71051_((Vec3i)pos) && this.blocks.containsKey(pos)) {
            return this.processBlockStateForPrinting((BlockState)this.blocks.get(pos));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public Map<BlockPos, BlockState> getBlockMap() {
        return this.blocks;
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public Holder<Biome> m_204166_(BlockPos pos) {
        return this.level.m_9598_().m_255025_(Registries.f_256952_).m_255043_(Biomes.f_48202_);
    }

    public int m_45517_(LightLayer lightLayer, BlockPos pos) {
        return 15;
    }

    public float m_7717_(Direction face, boolean hasShade) {
        return 1.0f;
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public List<Entity> m_6249_(Entity arg0, AABB arg1, Predicate<? super Entity> arg2) {
        return Collections.emptyList();
    }

    public <T extends Entity> List<T> m_6443_(Class<T> arg0, AABB arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    public int m_7445_() {
        return 0;
    }

    public boolean m_7433_(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.m_8055_(pos));
    }

    public boolean m_46961_(BlockPos arg0, boolean arg1) {
        return this.m_7731_(arg0, Blocks.f_50016_.m_49966_(), 3);
    }

    public boolean m_7471_(BlockPos arg0, boolean arg1) {
        return this.m_7731_(arg0, Blocks.f_50016_.m_49966_(), 3);
    }

    public boolean m_7731_(BlockPos pos, BlockState arg1, int arg2) {
        BlockEntity blockEntity;
        pos = pos.m_7949_().m_121996_((Vec3i)this.anchor);
        this.bounds = BBHelper.encapsulate((BoundingBox)this.bounds, (BlockPos)pos);
        this.blocks.put(pos, arg1);
        if (this.blockEntities.containsKey(pos) && !(blockEntity = (BlockEntity)this.blockEntities.get(pos)).m_58903_().m_155262_(arg1)) {
            this.blockEntities.remove(pos);
            this.renderedBlockEntities.remove(blockEntity);
        }
        if ((blockEntity = this.m_7702_(pos)) != null) {
            this.blockEntities.put(pos, blockEntity);
        }
        return true;
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void setBounds(BoundingBox bounds) {
        this.bounds = bounds;
    }

    public Iterable<BlockEntity> getBlockEntities() {
        return this.blockEntities.values();
    }

    public Iterable<BlockEntity> getRenderedBlockEntities() {
        return this.renderedBlockEntities;
    }

    protected BlockState processBlockStateForPrinting(BlockState state) {
        if (state.m_60734_() instanceof AbstractFurnaceBlock && state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public ServerLevel m_6018_() {
        if (this.level instanceof ServerLevel) {
            return (ServerLevel)this.level;
        }
        throw new IllegalStateException("Cannot use IServerWorld#getWorld in a client environment");
    }
}

