/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.util;

import com.obscuria.obscureapi.client.TooltipBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    public static void addLore(String itemID) {
        ResourceLocation registry = new ResourceLocation(itemID);
        TooltipBuilder.Lore.add(registry.m_135827_(), itemID, registry.m_135815_());
    }

    public static void addLore(String itemID, String translationKey) {
        TooltipBuilder.Lore.add(new ResourceLocation(itemID).m_135827_(), itemID, translationKey);
    }

    public static void addLore(String modID, String itemID, String translationKey) {
        TooltipBuilder.Lore.add(modID, itemID, translationKey);
    }

    public static void addKnowledge(String itemID) {
        ResourceLocation registry = new ResourceLocation(itemID);
        TooltipBuilder.Knowledge.add(registry.m_135827_(), itemID, registry.m_135815_());
    }

    public static void addKnowledge(String itemID, String translationKey) {
        TooltipBuilder.Knowledge.add(new ResourceLocation(itemID).m_135827_(), itemID, translationKey);
    }

    public static void addKnowledge(String modID, String itemID, String translationKey) {
        TooltipBuilder.Knowledge.add(modID, itemID, translationKey);
    }

    @SafeVarargs
    public static int getArmorPieces(LivingEntity entity, Class<? extends Item> ... armors) {
        boolean HEAD = false;
        boolean CHEST = false;
        boolean LEGS = false;
        boolean FEET = false;
        for (Class<? extends Item> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, EquipmentSlot.HEAD, item)) continue;
            HEAD = true;
        }
        for (Class<? extends Item> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, EquipmentSlot.CHEST, item)) continue;
            CHEST = true;
        }
        for (Class<? extends Item> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, EquipmentSlot.LEGS, item)) continue;
            LEGS = true;
        }
        for (Class<? extends Item> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, EquipmentSlot.FEET, item)) continue;
            FEET = true;
        }
        return (HEAD ? 1 : 0) + (CHEST ? 1 : 0) + (LEGS ? 1 : 0) + (FEET ? 1 : 0);
    }

    public static boolean hasItemInSlot(LivingEntity entity, EquipmentSlot slot, Class<? extends Item> item) {
        return item.isAssignableFrom(entity.m_6844_(slot).m_41720_().getClass());
    }

    @Nullable
    public static CompoundTag getData(ItemStack stack) {
        return stack.m_41783_() == null ? null : stack.m_41783_().m_128469_("ObscureData");
    }

    public static CompoundTag getOrCreateData(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("ObscureData")) {
            stack.m_41784_().m_128365_("ObscureData", (Tag)new CompoundTag());
        }
        return stack.m_41784_().m_128469_("ObscureData");
    }

    @Nullable
    public static CompoundTag getPerks(ItemStack stack) {
        CompoundTag data = ItemUtils.getData(stack);
        return data == null ? null : data.m_128469_("Perks");
    }

    public static CompoundTag getOrCreatePerks(ItemStack stack) {
        if (!ItemUtils.getOrCreateData(stack).m_128441_("Perks")) {
            ItemUtils.getOrCreateData(stack).m_128365_("Perks", (Tag)new CompoundTag());
        }
        return ItemUtils.getOrCreateData(stack).m_128469_("Perks");
    }

    public static boolean hasPerks(ItemStack stack) {
        CompoundTag perks = ItemUtils.getPerks(stack);
        return perks != null && !perks.m_128456_();
    }

    public static boolean hasPerk(ItemStack stack, ResourceLocation perk) {
        CompoundTag perks = ItemUtils.getPerks(stack);
        return perks != null && perks.m_128441_(perk.toString());
    }

    public static boolean hasPerk(ItemStack stack, String perk) {
        CompoundTag perks = ItemUtils.getPerks(stack);
        return perks != null && perks.m_128441_(perk);
    }

    public static void addPerk(ItemStack stack, ResourceLocation perk, int level) {
        ItemUtils.getOrCreatePerks(stack).m_128405_(perk.toString(), level);
    }

    public static void removePerk(ItemStack stack, ResourceLocation perk) {
        CompoundTag perks = ItemUtils.getPerks(stack);
        if (perks != null && perks.m_128441_(perk.toString())) {
            perks.m_128473_(perk.toString());
        }
    }

    public static void removePerk(ItemStack stack, String perk) {
        CompoundTag perks = ItemUtils.getPerks(stack);
        if (perks != null && perks.m_128441_(perk)) {
            perks.m_128473_(perk);
        }
    }
}

