/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.BiomeChecker;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawPieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MonasteryStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.UmvuthanaGrovePieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.UmvuthanaGroveStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberPieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberStructure;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class StructureTypeHandler {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPE_REG = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"mowziesmobs");
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECE_TYPE_REG = DeferredRegister.create((ResourceKey)Registries.f_256786_, (String)"mowziesmobs");
    public static RegistryObject<StructureType<WroughtnautChamberStructure>> WROUGHTNAUT_CHAMBER = StructureTypeHandler.registerStructureType("wrought_chamber", () -> () -> WroughtnautChamberStructure.CODEC);
    public static RegistryObject<StructurePieceType> WROUGHTNAUT_CHAMBER_PIECE = StructureTypeHandler.registerStructurePieceType("wrought_chamber_template", WroughtnautChamberPieces.Piece::new);
    public static RegistryObject<StructureType<UmvuthanaGroveStructure>> UMVUTHANA_GROVE = StructureTypeHandler.registerStructureType("umvuthana_grove", () -> () -> UmvuthanaGroveStructure.CODEC);
    public static RegistryObject<StructurePieceType> UMVUTHANA_GROVE_PIECE = StructureTypeHandler.registerStructurePieceType("umvuthana_grove_template", UmvuthanaGrovePieces.Piece::new);
    public static RegistryObject<StructurePieceType> UMVUTHANA_FIREPIT = StructureTypeHandler.registerStructurePieceType("umvuthana_firepit", UmvuthanaGrovePieces.FirepitPiece::new);
    public static RegistryObject<StructureType<FrostmawStructure>> FROSTMAW = StructureTypeHandler.registerStructureType("frostmaw_spawn", () -> () -> FrostmawStructure.CODEC);
    public static RegistryObject<StructurePieceType> FROSTMAW_PIECE = StructureTypeHandler.registerStructurePieceType("frostmaw_template", FrostmawPieces.FrostmawPiece::new);
    public static RegistryObject<StructureType<MonasteryStructure>> MONASTERY = StructureTypeHandler.registerStructureType("monastery", () -> () -> MonasteryStructure.CODEC);
    public static BiomeChecker FERROUS_WROUGHTNAUT_BIOME_CHECKER;
    public static final Set<Holder<Biome>> FERROUS_WROUGHTNAUT_BIOMES;
    public static BiomeChecker UMVUTHI_BIOME_CHECKER;
    public static final Set<Holder<Biome>> UMVUTHI_BIOMES;
    public static BiomeChecker FROSTMAW_BIOME_CHECKER;
    public static final Set<Holder<Biome>> FROSTMAW_BIOMES;
    public static BiomeChecker SCULPTOR_BIOME_CHECKER;
    public static final Set<Holder<Biome>> SCULPTOR_BIOMES;

    private static <T extends Structure> RegistryObject<StructureType<T>> registerStructureType(String name, Supplier<StructureType<T>> structure) {
        return STRUCTURE_TYPE_REG.register(name, structure);
    }

    private static <T extends Structure> RegistryObject<StructurePieceType> registerStructurePieceType(String name, StructurePieceType structurePieceType) {
        return STRUCTURE_PIECE_TYPE_REG.register(name, () -> structurePieceType);
    }

    public static void addBiomeSpawns(Holder<Biome> biomeKey) {
        if (FERROUS_WROUGHTNAUT_BIOME_CHECKER == null) {
            FERROUS_WROUGHTNAUT_BIOME_CHECKER = new BiomeChecker(ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.generationDistance.get() >= 0 && FERROUS_WROUGHTNAUT_BIOME_CHECKER.isBiomeInConfig(biomeKey)) {
            FERROUS_WROUGHTNAUT_BIOMES.add(biomeKey);
        }
        if (UMVUTHI_BIOME_CHECKER == null) {
            UMVUTHI_BIOME_CHECKER = new BiomeChecker(ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig.generationDistance.get() >= 0 && UMVUTHI_BIOME_CHECKER.isBiomeInConfig(biomeKey)) {
            UMVUTHI_BIOMES.add(biomeKey);
        }
        if (FROSTMAW_BIOME_CHECKER == null) {
            FROSTMAW_BIOME_CHECKER = new BiomeChecker(ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.generationDistance.get() >= 0 && FROSTMAW_BIOME_CHECKER.isBiomeInConfig(biomeKey)) {
            FROSTMAW_BIOMES.add(biomeKey);
        }
        if (SCULPTOR_BIOME_CHECKER == null) {
            SCULPTOR_BIOME_CHECKER = new BiomeChecker(ConfigHandler.COMMON.MOBS.SCULPTOR.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.SCULPTOR.generationConfig.generationDistance.get() >= 0 && SCULPTOR_BIOME_CHECKER.isBiomeInConfig(biomeKey)) {
            SCULPTOR_BIOMES.add(biomeKey);
        }
    }

    static {
        FERROUS_WROUGHTNAUT_BIOMES = new HashSet<Holder<Biome>>();
        UMVUTHI_BIOMES = new HashSet<Holder<Biome>>();
        FROSTMAW_BIOMES = new HashSet<Holder<Biome>>();
        SCULPTOR_BIOMES = new HashSet<Holder<Biome>>();
    }
}

