/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientboundMapItemDataPacket.class})
public class MapItemDataPacketMixin
implements IMapDataPacketExtension {
    @Shadow
    @Final
    @Nullable
    private MapItemSavedData.MapPatch f_178968_;
    @Shadow
    @Final
    private int f_132415_;
    @Unique
    private CustomMapDecoration[] moonlight$customDecorations = null;
    @Unique
    private CompoundTag moonlight$customData = null;
    @Unique
    private int moonlight$mapCenterX = 0;
    @Unique
    private int moonlight$mapCenterZ = 0;
    @Unique
    private ResourceLocation moonlight$dimension = Level.f_46428_.m_135782_();

    @Inject(method={"<init>(IBZLjava/util/Collection;Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData$MapPatch;)V"}, at={@At(value="RETURN")})
    private void addExtraCenterAndDimension(int mapId, byte b, boolean bl, Collection collection, MapItemSavedData.MapPatch mapPatch, CallbackInfo ci) {
        MapItemSavedData data;
        ServerLevel level = PlatHelper.getCurrentServer().m_129880_(Level.f_46428_);
        if (level != null && (data = Moonlight.getMapDataFromKnownKeys(level, mapId)) != null) {
            this.moonlight$mapCenterX = data.f_256718_;
            this.moonlight$mapCenterZ = data.f_256789_;
            this.moonlight$dimension = data.f_77887_.m_135782_();
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")})
    private void readExtraData(FriendlyByteBuf buf, CallbackInfo ci) {
        if (!buf.isReadable()) {
            return;
        }
        if (buf.readBoolean()) {
            this.moonlight$dimension = buf.m_130281_();
            this.moonlight$mapCenterX = buf.m_130242_();
            this.moonlight$mapCenterZ = buf.m_130242_();
        }
        if (buf.readBoolean()) {
            this.moonlight$customDecorations = new CustomMapDecoration[buf.m_130242_()];
            for (int m = 0; m < this.moonlight$customDecorations.length; ++m) {
                MapDecorationType<?, ?> type = MapDataInternal.get(buf.m_130281_());
                if (type == null) continue;
                this.moonlight$customDecorations[m] = type.loadDecorationFromBuffer(buf);
            }
        }
        if (buf.readBoolean()) {
            this.moonlight$customData = buf.m_130260_();
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeExtraData(FriendlyByteBuf buf, CallbackInfo ci) {
        buf.writeBoolean(this.moonlight$dimension != null);
        if (this.moonlight$dimension != null) {
            buf.m_130085_(this.moonlight$dimension);
            buf.m_130130_(this.moonlight$mapCenterX);
            buf.m_130130_(this.moonlight$mapCenterZ);
        }
        buf.writeBoolean(this.moonlight$customDecorations != null);
        if (this.moonlight$customDecorations != null) {
            buf.m_130130_(this.moonlight$customDecorations.length);
            for (CustomMapDecoration decoration : this.moonlight$customDecorations) {
                buf.m_130085_(Utils.getID(decoration.getType()));
                decoration.saveToBuffer(buf);
            }
        }
        buf.writeBoolean(this.moonlight$customData != null);
        if (this.moonlight$customData != null) {
            buf.m_130079_(this.moonlight$customData);
        }
    }

    @Override
    @NotNull
    public void moonlight$sendCustomDecorations(Collection<CustomMapDecoration> decorations) {
        if (PlatHelper.getPhysicalSide().isClient()) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            decorations = decorations.stream().map(e -> {
                e.saveToBuffer(buffer);
                Object d = e.getType().loadDecorationFromBuffer(buffer);
                return d;
            }).toList();
        }
        this.moonlight$customDecorations = (CustomMapDecoration[])decorations.toArray(CustomMapDecoration[]::new);
    }

    @Override
    public void moonlight$sendCustomMapDataTag(CompoundTag dataTag) {
        this.moonlight$customData = dataTag;
    }

    @Override
    public CompoundTag moonlight$getCustomMapDataTag() {
        return this.moonlight$customData;
    }

    @Override
    public MapItemSavedData.MapPatch moonlight$getColorPatch() {
        return this.f_178968_;
    }

    @Override
    public ResourceKey<Level> moonlight$getDimension() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.moonlight$dimension);
    }

    @Inject(method={"applyToMap"}, at={@At(value="HEAD")})
    private void handleExtraData(MapItemSavedData mapData, CallbackInfo ci) {
        CustomMapDecoration[] serverDeco = this.moonlight$customDecorations;
        CompoundTag serverData = this.moonlight$customData;
        mapData.f_256718_ = this.moonlight$mapCenterX;
        mapData.f_256789_ = this.moonlight$mapCenterZ;
        mapData.f_77887_ = this.moonlight$getDimension();
        if (mapData instanceof ExpandedMapData) {
            ExpandedMapData ed = (ExpandedMapData)mapData;
            Map<String, CustomMapDecoration> decorations = ed.getCustomDecorations();
            if (serverDeco != null) {
                decorations.clear();
                for (int i = 0; i < serverDeco.length; ++i) {
                    CustomMapDecoration customDecoration = serverDeco[i];
                    if (customDecoration != null) {
                        decorations.put("icon-" + i, customDecoration);
                        continue;
                    }
                    Moonlight.LOGGER.warn("Failed to load custom map decoration, skipping");
                }
            }
            if (serverData != null) {
                Map<ResourceLocation, CustomMapData<?>> customData = ed.getCustomData();
                for (CustomMapData customMapData : customData.values()) {
                    customMapData.loadUpdateTag(this.moonlight$customData);
                }
            }
            for (MapBlockMarker<?> m : MapDataInternal.getDynamicClient(this.f_132415_, mapData)) {
                Object obj = m.createDecorationFromMarker(mapData);
                if (obj == null) continue;
                decorations.put(m.getMarkerId(), (CustomMapDecoration)obj);
            }
        }
    }
}

