/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.forge;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.ModFlowingFluid;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.recipe.forge.OptionalRecipeCondition;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.AntiRepostWarning;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class RegHelperImpl {
    private static final Map<ResourceKey<? extends Registry<?>>, Map<String, DeferredRegister<?>>> REGISTRIES = new ConcurrentHashMap();
    private static final ResourceLocation BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE = new ResourceLocation("minecraft:blockstatetopointofinteresttype");

    public static <T, E extends T> RegSupplier<E> register(ResourceLocation name, Supplier<E> supplier, Registry<T> reg) {
        return RegHelperImpl.register(name, supplier, reg.m_123023_());
    }

    public static <T, E extends T> RegSupplier<E> register(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> regKey) {
        if (supplier == null) {
            throw new IllegalArgumentException("Registry entry Supplier for " + String.valueOf(name) + " can't be null");
        }
        if (name.m_135827_().equals("minecraft")) {
            throw new IllegalArgumentException("Registering under minecraft namespace is not supported");
        }
        Map m = REGISTRIES.computeIfAbsent(regKey, h -> new ConcurrentHashMap());
        String modId = name.m_135827_();
        DeferredRegister registry = m.computeIfAbsent(modId, c -> {
            if (PlatHelper.getPhysicalSide().isClient()) {
                AntiRepostWarning.addMod(modId);
            }
            DeferredRegister r = DeferredRegister.create((ResourceKey)regKey, (String)modId);
            IEventBus bus = RegHelperImpl.getModEventBus(modId);
            r.register(bus);
            return r;
        });
        return new EntryWrapper(registry.register(name.m_135815_(), () -> {
            Object obj = supplier.get();
            if (regKey.equals((Object)Registries.f_256808_) && obj instanceof ModFlowingFluid) {
                ModFlowingFluid fluid = (ModFlowingFluid)((Object)((Object)obj));
                if (fluid.hasCustomFluidType) {
                    RegHelperImpl.register(name, () -> ((ModFlowingFluid)fluid).getFluidType(), ForgeRegistries.Keys.FLUID_TYPES);
                }
            }
            return obj;
        }));
    }

    private static IEventBus getModEventBus(String modId) {
        IEventBus bus;
        ModContainer cont = (ModContainer)ModList.get().getModContainerById(modId).get();
        if (!(cont instanceof FMLModContainer)) {
            Moonlight.LOGGER.warn("Failed to get mod container for mod {}", (Object)modId);
            bus = FMLJavaModLoadingContext.get().getModEventBus();
        } else {
            FMLModContainer container = (FMLModContainer)cont;
            bus = container.getEventBus();
        }
        return bus;
    }

    public static <T, E extends T> RegSupplier<E> registerAsync(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> reg) {
        return RegHelperImpl.register(name, supplier, reg);
    }

    public static <T> void registerInBatch(Registry<T> reg, Consumer<Registrator<T>> eventListener) {
        Consumer<RegisterEvent> eventConsumer = event -> {
            if (event.getVanillaRegistry() == reg) {
                eventListener.accept((arg_0, arg_1) -> ((IForgeRegistry)event.getForgeRegistry()).register(arg_0, arg_1));
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static <C extends AbstractContainerMenu> RegSupplier<MenuType<C>> registerMenuType(ResourceLocation name, TriFunction<Integer, Inventory, FriendlyByteBuf, C> containerFactory) {
        return RegHelperImpl.register(name, () -> IForgeMenuType.create(containerFactory::apply), Registries.f_256798_);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange, int updateInterval) {
        return RegHelperImpl.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)category).m_20699_(width, height).m_20712_(name.toString()), Registries.f_256939_);
    }

    public static <T extends Fluid> RegSupplier<T> registerFluid(ResourceLocation name, Supplier<T> fluid) {
        RegSupplier<T> f = RegHelperImpl.register(name, fluid, Registries.f_256808_);
        return f;
    }

    public static <T extends CraftingRecipe> RegSupplier<RecipeSerializer<T>> registerSpecialRecipe(ResourceLocation name, SimpleCraftingRecipeSerializer.Factory<T> factory) {
        return RegHelper.registerRecipeSerializer(name, () -> new SimpleCraftingRecipeSerializer(factory));
    }

    public static RegSupplier<CreativeModeTab> registerCreativeModeTab(ResourceLocation name, boolean hasSearchBar, List<ResourceLocation> afterEntries, List<ResourceLocation> beforeEntries, Consumer<CreativeModeTab.Builder> configurator) {
        return RegHelperImpl.register(name, () -> {
            CreativeModeTab.Builder b = CreativeModeTab.builder();
            configurator.accept(b);
            if (!beforeEntries.isEmpty()) {
                b.withTabsBefore((ResourceLocation[])beforeEntries.toArray(ResourceLocation[]::new));
            }
            if (!afterEntries.isEmpty()) {
                b.withTabsBefore((ResourceLocation[])afterEntries.toArray(ResourceLocation[]::new));
            }
            if (hasSearchBar) {
                b.withSearchBar();
            }
            return b.m_257652_();
        }, Registries.f_279569_);
    }

    public static void registerItemBurnTime(Item item, int burnTime) {
    }

    public static void registerBlockFlammability(Block item, int fireSpread, int flammability) {
        ((FireBlock)Blocks.f_50083_).m_53444_(item, fireSpread, flammability);
    }

    public static void registerVillagerTrades(VillagerProfession profession, int level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        Moonlight.assertInitPhase();
        Consumer<VillagerTradesEvent> eventConsumer = event -> {
            if (event.getType() == profession) {
                List list = (List)event.getTrades().get(level);
                factories.accept(list);
            }
        };
        MinecraftForge.EVENT_BUS.addListener(eventConsumer);
    }

    public static void registerWanderingTraderTrades(int level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        Moonlight.assertInitPhase();
        Consumer<WandererTradesEvent> eventConsumer = event -> {
            if (level == 0) {
                factories.accept(event.getGenericTrades());
            } else {
                factories.accept(event.getRareTrades());
            }
        };
        MinecraftForge.EVENT_BUS.addListener(eventConsumer);
    }

    public static void addAttributeRegistration(Consumer<RegHelper.AttributeEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<EntityAttributeCreationEvent> eventConsumer = event -> eventListener.accept((e, b) -> event.put(e, b.m_22265_()));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addCommandRegistration(RegHelper.CommandRegistration eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterCommandsEvent> eventConsumer = event -> eventListener.accept((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        MinecraftForge.EVENT_BUS.addListener(eventConsumer);
    }

    public static void addSpawnPlacementsRegistration(Consumer<RegHelper.SpawnPlacementEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<SpawnPlacementRegisterEvent> eventConsumer = event -> {
            PlacementEventImpl spawnPlacementEvent = new PlacementEventImpl((SpawnPlacementRegisterEvent)event);
            eventListener.accept(spawnPlacementEvent);
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void registerSimpleRecipeCondition(ResourceLocation id, Predicate<String> predicate) {
        Moonlight.assertInitPhase();
        CraftingHelper.register((IConditionSerializer)new OptionalRecipeCondition(id, predicate));
    }

    public static void addItemsToTabsRegistration(Consumer<RegHelper.ItemToTabEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<BuildCreativeModeTabContentsEvent> eventConsumer = event -> {
            RegHelper.ItemToTabEvent itemToTabEvent = new RegHelper.ItemToTabEvent((tab, target, after, items) -> {
                if (tab != event.getTabKey()) {
                    return;
                }
                if (target == null) {
                    event.m_246601_(items);
                } else {
                    MutableHashedLinkedMap entries = event.getEntries();
                    ItemStack lastValid = null;
                    for (Map.Entry e : entries) {
                        ItemStack item = (ItemStack)e.getKey();
                        if (!item.m_246617_(event.getFlags())) continue;
                        boolean isValid = target.test(item);
                        if (after.booleanValue() && lastValid != null && !isValid) {
                            List rev = Lists.reverse(new ArrayList(items));
                            for (ItemStack ni2 : rev) {
                                entries.putAfter((Object)lastValid, (Object)ni2, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                            }
                            return;
                        }
                        if (isValid) {
                            lastValid = item;
                        }
                        if (after.booleanValue() || !isValid) continue;
                        items.forEach(ni -> entries.putBefore((Object)item, ni, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                        return;
                    }
                    for (ItemStack ni3 : items) {
                        entries.put((Object)ni3, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    }
                }
            });
            eventListener.accept(itemToTabEvent);
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, eventConsumer);
    }

    public static void addLootTableInjects(Consumer<RegHelper.LootInjectEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<LootTableLoadEvent> eventConsumer = event -> eventListener.accept(new RegHelper.LootInjectEvent((LootTableLoadEvent)event){
            final /* synthetic */ LootTableLoadEvent val$event;
            {
                this.val$event = lootTableLoadEvent;
            }

            @Override
            public ResourceLocation getTable() {
                return this.val$event.getName();
            }

            @Override
            public void addTableReference(ResourceLocation targetId) {
                LootPool pool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)targetId)).m_79082_();
                this.val$event.getTable().addPool(pool);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(eventConsumer);
    }

    public static void registerFireworkRecipe(FireworkRocketItem.Shape shape, Item ingredient) {
        FireworkStarRecipe.f_43879_ = new HashMap(FireworkStarRecipe.f_43879_);
        FireworkStarRecipe.f_43879_.put(ingredient, shape);
        FireworkStarRecipe.f_43876_ = CompoundIngredient.of((Ingredient[])new Ingredient[]{FireworkStarRecipe.f_43876_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})});
    }

    public static <T> Supplier<EntityDataSerializer<T>> regEntityDataSerializer(ResourceLocation name, Supplier<EntityDataSerializer<T>> serializer) {
        return RegHelper.register(name, serializer, ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS);
    }

    public static void addBlocksToPOI(ResourceKey<PoiType> poi, Iterable<? extends Block> blocks) {
        Holder.Reference beehivePOI = BuiltInRegistries.f_256941_.m_246971_(poi);
        Set matchingStates = ((PoiType)beehivePOI.m_203334_()).f_27325_();
        HashSet<BlockState> newStates = new HashSet<BlockState>();
        try {
            for (Block block : blocks) {
                matchingStates.add(block.m_49966_());
                newStates.add(block.m_49966_());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add blocks to POI " + String.valueOf(poi.m_135782_()) + ". Somehow the set was not mutable?", e);
        }
        Map map = (Map)ForgeRegistries.POI_TYPES.getSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, Map.class);
        newStates.forEach(blockState -> {
            PoiType holder2 = map.put(blockState, (PoiType)beehivePOI.m_203334_());
            if (holder2 != null) {
                throw (IllegalStateException)Util.m_137570_((Throwable)new IllegalStateException(String.format(Locale.ROOT, "%s is defined in more than one PoI type", blockState)));
            }
        });
    }

    public record EntryWrapper<T>(RegistryObject<T> registryObject) implements RegSupplier<T>
    {
        @Override
        public T get() {
            return (T)this.registryObject.get();
        }

        @Override
        public ResourceLocation getId() {
            return this.registryObject.getId();
        }

        @Override
        public ResourceKey<T> getKey() {
            return this.registryObject.getKey();
        }

        @Override
        public Holder<T> getHolder() {
            return (Holder)this.registryObject.getHolder().get();
        }
    }

    record PlacementEventImpl(SpawnPlacementRegisterEvent event) implements RegHelper.SpawnPlacementEvent
    {
        @Override
        public <T extends Entity> void register(EntityType<T> entityType, SpawnPlacements.Type decoratorType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<T> decoratorPredicate) {
            this.event.register(entityType, decoratorType, heightMapType, decoratorPredicate, SpawnPlacementRegisterEvent.Operation.AND);
        }
    }
}

