/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.limitedbackpacks;

import java.util.Set;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.xewe.limitedbackpacks.LimitedBackpacks;

@Mod.EventBusSubscriber(modid="limitedbackpacks")
public class SlownessSystem {
    private static final Set<Item> TARGET_ITEMS = Set.of(Items.f_42503_);
    private static final int CHECK_INTERVAL = 20;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            int targetItemCount;
            Player player = event.player;
            if (player.f_19797_ % 20 == 0 && (targetItemCount = SlownessSystem.countTargetItems(player)) > 1) {
                int slownessLevel = Math.min(targetItemCount - 1, 5);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 25, slownessLevel, true, true));
            }
        }
    }

    private static int countTargetItems(Player player) {
        int count = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!LimitedBackpacks.isHeavyBackpack(stack)) continue;
            ++count;
        }
        ItemStack offhandStack = (ItemStack)player.m_150109_().f_35976_.get(0);
        if (LimitedBackpacks.isHeavyBackpack(offhandStack)) {
            ++count;
        }
        return count;
    }
}

