/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.legendaryitems.mixin;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.moddercoder.legendaryitems.item.CrescensCrossbowItem;
import net.moddercoder.legendaryitems.item.CrescensPowerCrossbowItem;
import net.moddercoder.legendaryitems.mixinexpander.IPlayerExpander;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements IPlayerExpander {
    @Unique
    private int ticksForResetCrescensCrossbowHits = 0;
    @Unique
    private int ticksForResetPowerCrescensCrossbow = 0;
    private int crossbowAutoReloadingTicks = 0;
    private int crossbowAutoReloadingTicksDuration = 0;
    private boolean shouldUpgradeCrescensCrossbowStack = false;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void injectTick(CallbackInfo callback) {
        Inventory inv;
        Player self = (Player)this;
        if (self.m_9236_().f_46443_) {
            return;
        }
        if (this.shouldUpgradeCrescensCrossbowStack) {
            InteractionHand[] hands;
            for (InteractionHand hand : hands = new InteractionHand[]{InteractionHand.MAIN_HAND, InteractionHand.OFF_HAND}) {
                ItemStack stack = self.m_21120_(hand);
                if (!(stack.m_41720_() instanceof CrescensCrossbowItem)) continue;
                self.m_21008_(hand, CrescensCrossbowItem.upgradeToPowerful(stack));
                break;
            }
            this.shouldUpgradeCrescensCrossbowStack = false;
        }
        if (this.ticksForResetCrescensCrossbowHits > 0) {
            --this.ticksForResetCrescensCrossbowHits;
            if (this.ticksForResetCrescensCrossbowHits <= 0) {
                inv = self.m_150109_();
                for (int slotId = 0; slotId < inv.m_6643_(); ++slotId) {
                    ItemStack stack = inv.m_8020_(slotId);
                    if (!(stack.m_41720_() instanceof CrescensCrossbowItem)) continue;
                    CrescensCrossbowItem.resetHits(stack);
                }
            }
        } else if (self.m_21206_().m_41720_() instanceof CrescensCrossbowItem || self.m_21205_().m_41720_() instanceof CrescensCrossbowItem) {
            this.resetTicksForResetCrescensCrossbowHits();
        }
        if (this.ticksForResetPowerCrescensCrossbow > 0) {
            --this.ticksForResetPowerCrescensCrossbow;
            if (this.ticksForResetPowerCrescensCrossbow <= 0) {
                inv = self.m_150109_();
                for (int slotId = 0; slotId < inv.m_6643_(); ++slotId) {
                    ItemStack stack = inv.m_8020_(slotId);
                    if (!(stack.m_41720_() instanceof CrescensPowerCrossbowItem)) continue;
                    inv.m_6836_(slotId, CrescensCrossbowItem.downgradeToBase(stack));
                }
            }
        } else if (self.m_21206_().m_41720_() instanceof CrescensPowerCrossbowItem || self.m_21205_().m_41720_() instanceof CrescensPowerCrossbowItem) {
            this.resetTicksForResetPowerCrescensCrossbow();
        }
    }

    @Override
    public void setShouldUpgradeCrescensCrossbowStack() {
        this.shouldUpgradeCrescensCrossbowStack = true;
    }

    @Override
    public int getCrossbowAutoReloadingTicks() {
        return this.crossbowAutoReloadingTicks;
    }

    @Override
    public int getCrossbowAutoReloadingTicksDuration() {
        return this.crossbowAutoReloadingTicksDuration;
    }

    private void setCrossbowAutoReloadingTicks(int ticks) {
        this.crossbowAutoReloadingTicksDuration = this.crossbowAutoReloadingTicks = ticks;
    }

    @Override
    @Unique
    public void resetTicksForResetCrescensCrossbowHits() {
        this.ticksForResetCrescensCrossbowHits = 240;
    }

    @Override
    @Unique
    public void addPowerCrescensCrossbowTime() {
        this.ticksForResetPowerCrescensCrossbow += 20;
    }

    private void resetTicksForResetPowerCrescensCrossbow() {
        this.ticksForResetPowerCrescensCrossbow = 300;
    }
}

