/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.legendaryitems.mixin;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.moddercoder.legendaryitems.damage.ModDamageTypes;
import net.moddercoder.legendaryitems.item.CrescensPowerCrossbowItem;
import net.moddercoder.legendaryitems.item.ModItems;
import net.moddercoder.legendaryitems.nbt.CrossbowNbtUtil;
import net.moddercoder.legendaryitems.sounds.ModSoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    private static ItemStack tempCrossbowStack;

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectUse(Level world, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> callback) {
        ItemStack stack = player.m_21120_(hand);
        if (CrossbowNbtUtil.isAutoReloading(stack)) {
            if (CrossbowItem.m_40932_((ItemStack)stack)) {
                CrossbowItem.m_40887_((Level)world, (LivingEntity)player, (InteractionHand)hand, (ItemStack)stack, (float)(CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.6f : 3.15f), (float)1.0f);
                CrossbowItem.m_40884_((ItemStack)stack, (boolean)false);
                player.m_36335_().m_41524_(stack.m_41720_(), CrossbowItem.m_40939_((ItemStack)stack));
                callback.setReturnValue((Object)InteractionResultHolder.m_19096_((Object)stack));
            } else if (!player.m_6298_(stack).m_41619_() && CrossbowItem.m_40859_((LivingEntity)player, (ItemStack)stack)) {
                CrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11841_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
                callback.setReturnValue((Object)InteractionResultHolder.m_19096_((Object)stack));
            }
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    private void injectAppendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag, CallbackInfo callback) {
        if (CrossbowNbtUtil.isAutoReloading(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.crossbow.auto_reloading").m_130940_(ChatFormatting.GOLD));
        }
    }

    @Inject(method={"tryLoadProjectiles"}, at={@At(value="HEAD")})
    private static void tryLoadProjectiles(LivingEntity entity, ItemStack stack, CallbackInfoReturnable<Boolean> callback) {
        tempCrossbowStack = stack;
    }

    @ModifyVariable(method={"tryLoadProjectiles"}, at=@At(value="STORE"), ordinal=0)
    private static boolean tryLoadProjectiles(boolean infiniteAmmo) {
        return infiniteAmmo || tempCrossbowStack.m_41720_() instanceof CrescensPowerCrossbowItem;
    }

    @ModifyVariable(method={"tryLoadProjectiles"}, at=@At(value="STORE"), ordinal=1)
    private static int tryLoadProjectiles(int arrowCount) {
        return tempCrossbowStack.m_41720_() instanceof CrescensPowerCrossbowItem ? 1 : arrowCount;
    }

    @Inject(method={"getArrow"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void getArrow(Level world, LivingEntity entity, ItemStack crossbowStack, ItemStack arrowStack, CallbackInfoReturnable<AbstractArrow> callback, ArrowItem arrowItem, AbstractArrow abstractArrow) {
        if (crossbowStack.m_41720_() instanceof CrescensPowerCrossbowItem) {
            abstractArrow.getPersistentData().m_128379_(ModDamageTypes.getArrowBypassInvulnerable().m_135782_().toString(), true);
            abstractArrow.m_36781_(abstractArrow.m_36789_() + 3.0);
            abstractArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }

    @Inject(method={"shootProjectile"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")}, cancellable=true)
    private static void injectShootProjectileBeforePlaySound(Level world, LivingEntity entity, InteractionHand hand, ItemStack crossbowStack, ItemStack projectileStack, float pitch, boolean infinity, float volume, float force, float angle, CallbackInfo callback) {
        if (crossbowStack.m_41720_() instanceof CrescensPowerCrossbowItem) {
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ModSoundEvents.INSTANCE.getCRESCENS_POWER_SHOOT().get(), SoundSource.PLAYERS, 0.8f, pitch);
            callback.cancel();
        }
    }

    @Inject(method={"getChargeDuration"}, at={@At(value="RETURN")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void injectGetChargeDuration(ItemStack stack, CallbackInfoReturnable<Integer> callback, int quickChargeLevel) {
        int reloadingTicks;
        int resultReloadingTicks = reloadingTicks = ((Integer)callback.getReturnValue()).intValue();
        boolean autoReloading = CrossbowNbtUtil.isAutoReloading(stack);
        if (autoReloading) {
            resultReloadingTicks += 25;
        }
        if (stack.m_150930_((Item)ModItems.getCRESCENS_POWER_CROSSBOW().get())) {
            resultReloadingTicks = autoReloading ? (resultReloadingTicks -= 10) : (resultReloadingTicks -= resultReloadingTicks > 10 ? 5 : 0);
        }
        if (stack.m_150930_((Item)ModItems.getCRESCENS_CROSSBOW().get()) && stack.m_41784_().m_128471_("IsCrescensReloadingBoost")) {
            resultReloadingTicks = (int)Math.ceil((float)resultReloadingTicks * 0.7f);
        }
        if (resultReloadingTicks != reloadingTicks) {
            callback.setReturnValue((Object)Math.max(resultReloadingTicks, 0));
        }
    }
}

