/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.legendaryitems.item;

import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.moddercoder.legendaryitems.client.gui.screen.ScreenHelper;
import net.moddercoder.legendaryitems.item.QuiverItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B8\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004J8\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR,\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lnet/moddercoder/legendaryitems/item/QuiverItem;", "Lnet/minecraft/world/item/Item;", "supportedProjectile", "Lkotlin/Function1;", "Lnet/minecraft/world/item/ItemStack;", "Lkotlin/ParameterName;", "name", "stack", "", "inventorySize", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "(Lkotlin/jvm/functions/Function1;ILnet/minecraft/world/item/Item$Properties;)V", "getInventorySize", "()I", "getSupportedProjectile", "()Lkotlin/jvm/functions/Function1;", "isSuitableProjectiles", "projectilesStack", "overrideOtherStackedOnMe", "otherStack", "slot", "Lnet/minecraft/world/inventory/Slot;", "clickAction", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "access", "Lnet/minecraft/world/entity/SlotAccess;", "overrideStackedOnOther", "tryToAddProjectiles", "use", "Lnet/minecraft/world/InteractionResultHolder;", "world", "Lnet/minecraft/world/level/Level;", "hand", "Lnet/minecraft/world/InteractionHand;", "Companion", "ItemStackObservable", "legendaryitems-1.20.1"})
public final class QuiverItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<ItemStack, Boolean> supportedProjectile;
    private final int inventorySize;
    @NotNull
    public static final String NBT_SELECTED_SLOT_NAME = "SelectedSlot";
    @NotNull
    private static final String NBT_PROJECTILES_INVENTORY_NAME = "Projectiles";
    @NotNull
    private static final Function1<ItemStack, Boolean> ONLY_ARROWS = Companion.ONLY_ARROWS.1.INSTANCE;

    public QuiverItem(@NotNull Function1<? super ItemStack, Boolean> supportedProjectile, int inventorySize, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter(supportedProjectile, (String)"supportedProjectile");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.m_41487_(1));
        this.supportedProjectile = supportedProjectile;
        this.inventorySize = inventorySize;
    }

    @NotNull
    public final Function1<ItemStack, Boolean> getSupportedProjectile() {
        return this.supportedProjectile;
    }

    public final int getInventorySize() {
        return this.inventorySize;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(stack)");
            return interactionResultHolder;
        }
        Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
        if (Companion.isNotQuiverItem(stack)) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(stack)");
            return interactionResultHolder;
        }
        if (hand != InteractionHand.OFF_HAND || player.m_21205_().m_41720_().m_8105_(player.m_21205_()) <= 0) {
            CompoundTag compoundTag = stack.m_41783_();
            if (compoundTag == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(stack)");
                return interactionResultHolder;
            }
            CompoundTag tag = compoundTag;
            if (!tag.m_128441_(NBT_SELECTED_SLOT_NAME)) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(stack)");
                return interactionResultHolder;
            }
            byte selectedSlot = tag.m_128445_(NBT_SELECTED_SLOT_NAME);
            ItemStack[] itemStackArray = Companion.getProjectiles(stack);
            if (itemStackArray == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(stack)");
                return interactionResultHolder;
            }
            ItemStack[] projectiles = itemStackArray;
            if (world.f_46443_) {
                Minecraft minecraft = Minecraft.m_91087_();
                Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance()");
                ScreenHelper.INSTANCE.openQuiverScreen(selectedSlot, this.inventorySize, projectiles, minecraft);
            }
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19096_((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(stack)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(stack)");
        return interactionResultHolder;
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player, @NotNull SlotAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)otherStack, (String)"otherStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        return this.tryToAddProjectiles(stack, otherStack, clickAction);
    }

    public boolean m_142207_(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack otherStack = slot.m_7993_();
        if (otherStack.m_41619_() && clickAction == ClickAction.SECONDARY) {
            ItemStack peekedProjectile = net.moddercoder.legendaryitems.item.QuiverItem$Companion.peekProjectile$default(Companion, stack, 0, 2, null);
            bl = !Intrinsics.areEqual((Object)peekedProjectile, (Object)ItemStack.f_41583_) ? !Intrinsics.areEqual((Object)Companion.popProjectile(stack, peekedProjectile.m_41613_(), slot), (Object)ItemStack.f_41583_) : false;
        } else {
            ItemStack itemStack = slot.m_7993_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"slot.item");
            bl = this.tryToAddProjectiles(stack, itemStack, clickAction);
        }
        return bl;
    }

    public final boolean isSuitableProjectiles(@NotNull ItemStack projectilesStack) {
        Intrinsics.checkNotNullParameter((Object)projectilesStack, (String)"projectilesStack");
        return (Boolean)this.supportedProjectile.invoke((Object)projectilesStack);
    }

    private final boolean tryToAddProjectiles(ItemStack stack, ItemStack otherStack, ClickAction clickAction) {
        if (this.isSuitableProjectiles(otherStack)) {
            int countForAdd = switch (WhenMappings.$EnumSwitchMapping$0[clickAction.ordinal()]) {
                case 1 -> otherStack.m_41613_();
                case 2 -> 1;
                default -> throw new NoWhenBranchMatchedException();
            };
            return Companion.addProjectiles(stack, otherStack, countForAdd);
        }
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u001b\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bJ\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u001d\u001a\u00020\u0013J\"\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00132\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0018\u0010$\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010%\u001a\u00020\fH\u0002J\u0016\u0010&\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lnet/moddercoder/legendaryitems/item/QuiverItem$Companion;", "", "()V", "NBT_PROJECTILES_INVENTORY_NAME", "", "NBT_SELECTED_SLOT_NAME", "ONLY_ARROWS", "Lkotlin/Function1;", "Lnet/minecraft/world/item/ItemStack;", "Lkotlin/ParameterName;", "name", "stack", "", "getONLY_ARROWS", "()Lkotlin/jvm/functions/Function1;", "addProjectiles", "quiverStack", "projectilesStack", "countForAdd", "", "foundSlotForAdd", "getProjectiles", "", "(Lnet/minecraft/world/item/ItemStack;)[Lnet/minecraft/world/item/ItemStack;", "getProjectilesListTag", "Lnet/minecraft/nbt/ListTag;", "isEmpty", "isNotQuiverItem", "peekProjectile", "countForPeek", "popProjectile", "countForPop", "slot", "Lnet/minecraft/world/inventory/Slot;", "reinitNbt", "", "selectFirstAvailableSlot", "toRight", "selectSlot", "slotIndex", "legendaryitems-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<ItemStack, Boolean> getONLY_ARROWS() {
            return ONLY_ARROWS;
        }

        public final boolean isNotQuiverItem(@NotNull ItemStack quiverStack) {
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            if (!(quiverStack.m_41720_() instanceof QuiverItem)) {
                return true;
            }
            if (quiverStack.m_41783_() == null) {
                this.reinitNbt(quiverStack);
            }
            return false;
        }

        private final int foundSlotForAdd(ItemStack quiverStack, ItemStack projectilesStack) {
            if (this.isNotQuiverItem(quiverStack)) {
                return -1;
            }
            ListTag listTag = this.getProjectilesListTag(quiverStack);
            if (listTag == null) {
                return -1;
            }
            ListTag projectiles = listTag;
            if (projectiles.isEmpty()) {
                return 0;
            }
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            int inventorySize = ((QuiverItem)item).getInventorySize();
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)projectiles.m_128728_(i));
                if (stack.m_41619_()) {
                    return i;
                }
                if (!stack.m_150930_(projectilesStack.m_41720_()) || !Objects.equals(stack.m_41783_(), projectilesStack.m_41783_()) || stack.m_41613_() >= stack.m_41741_()) continue;
                return i;
            }
            return -1;
        }

        public final boolean isEmpty(@NotNull ItemStack quiverStack) {
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            if (this.isNotQuiverItem(quiverStack)) {
                return false;
            }
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            QuiverItem quiverItem = (QuiverItem)item;
            ListTag listTag = this.getProjectilesListTag(quiverStack);
            if (listTag == null) {
                return false;
            }
            ListTag projectilesListTag = listTag;
            int n = 0;
            int n2 = projectilesListTag.size();
            ItemStack[] itemStackArray = new ItemStack[n2];
            while (n < n2) {
                int n3 = n++;
                itemStackArray[n3] = ItemStack.m_41712_((CompoundTag)projectilesListTag.m_128728_(n3));
            }
            ItemStack[] projectiles = itemStackArray;
            CompoundTag compoundTag = quiverStack.m_41783_();
            Intrinsics.checkNotNull((Object)compoundTag);
            byte selectedSlot = compoundTag.m_128445_(QuiverItem.NBT_SELECTED_SLOT_NAME);
            int n4 = quiverItem.getInventorySize();
            for (int i = 0; i < n4; ++i) {
                int iterIndex = Math.floorMod(selectedSlot - i, quiverItem.getInventorySize());
                ItemStack projectile = projectiles[iterIndex];
                if (projectile.m_41619_()) continue;
                return false;
            }
            return true;
        }

        @Nullable
        public final ListTag getProjectilesListTag(@NotNull ItemStack quiverStack) {
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            if (this.isNotQuiverItem(quiverStack)) {
                return null;
            }
            CompoundTag tag = quiverStack.m_41783_();
            if (tag != null && tag.m_128425_(QuiverItem.NBT_PROJECTILES_INVENTORY_NAME, 9)) {
                return tag.m_128437_(QuiverItem.NBT_PROJECTILES_INVENTORY_NAME, 10);
            }
            return null;
        }

        @Nullable
        public final ItemStack[] getProjectiles(@NotNull ItemStack quiverStack) {
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            ListTag listTag = this.getProjectilesListTag(quiverStack);
            if (listTag == null) {
                return null;
            }
            ListTag projectilesListTag = listTag;
            int n = 0;
            int n2 = projectilesListTag.size();
            ItemStack[] itemStackArray = new ItemStack[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNullExpressionValue((Object)ItemStack.m_41712_((CompoundTag)projectilesListTag.m_128728_(n3)), (String)"of(projectilesListTag.getCompound(index))");
            }
            return itemStackArray;
        }

        public final boolean addProjectiles(@NotNull ItemStack quiverStack, @NotNull ItemStack projectilesStack, int countForAdd) {
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            Intrinsics.checkNotNullParameter((Object)projectilesStack, (String)"projectilesStack");
            if (this.isNotQuiverItem(quiverStack)) {
                return false;
            }
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            QuiverItem quiverItem = (QuiverItem)item;
            if (quiverItem.isSuitableProjectiles(projectilesStack)) {
                ListTag listTag = this.getProjectilesListTag(quiverStack);
                if (listTag == null) {
                    return false;
                }
                ListTag projectilesListTag = listTag;
                int slotForAdd = this.foundSlotForAdd(quiverStack, projectilesStack);
                if (slotForAdd != -1) {
                    ItemStack projectilesInSlot = ItemStack.m_41712_((CompoundTag)projectilesListTag.m_128728_(slotForAdd));
                    int incrementValue = Math.min(projectilesInSlot.m_41741_() - projectilesInSlot.m_41613_(), countForAdd);
                    if (incrementValue > 0) {
                        ItemStack projectilesInSlotNew = projectilesStack.m_255036_(projectilesInSlot.m_41613_() + incrementValue);
                        projectilesStack.m_41774_(incrementValue);
                        projectilesListTag.m_7615_(slotForAdd, (Tag)projectilesInSlotNew.m_41739_(new CompoundTag()));
                    }
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final ItemStack popProjectile(@NotNull ItemStack quiverStack, int countForPop, @Nullable Slot slot) {
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            if (this.isNotQuiverItem(quiverStack)) {
                ItemStack itemStack = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            QuiverItem quiverItem = (QuiverItem)item;
            ListTag listTag = this.getProjectilesListTag(quiverStack);
            if (listTag == null) {
                ItemStack itemStack = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            ListTag projectilesListTag = listTag;
            int n = 0;
            int n2 = projectilesListTag.size();
            ItemStack[] itemStackArray = new ItemStack[n2];
            while (n < n2) {
                int n3 = n++;
                itemStackArray[n3] = ItemStack.m_41712_((CompoundTag)projectilesListTag.m_128728_(n3));
            }
            ItemStack[] projectiles = itemStackArray;
            CompoundTag compoundTag = quiverStack.m_41783_();
            Intrinsics.checkNotNull((Object)compoundTag);
            byte selectedSlot = compoundTag.m_128445_(QuiverItem.NBT_SELECTED_SLOT_NAME);
            int n4 = quiverItem.getInventorySize();
            for (int i = 0; i < n4; ++i) {
                int iterIndex = Math.floorMod(selectedSlot - i, quiverItem.getInventorySize());
                ItemStack projectile = projectiles[iterIndex];
                if (projectile.m_41619_()) continue;
                int decrementValue = Math.min(projectile.m_41613_(), countForPop);
                ItemStack poppedProjectile = projectile.m_255036_(decrementValue);
                projectile.m_41774_(decrementValue);
                projectilesListTag.m_7615_(iterIndex, (Tag)projectile.m_41739_(new CompoundTag()));
                if (projectile.m_41619_()) {
                    this.selectFirstAvailableSlot(quiverStack, false);
                }
                Slot slot2 = slot;
                if (slot2 != null) {
                    slot2.m_5852_(poppedProjectile);
                }
                Intrinsics.checkNotNullExpressionValue((Object)poppedProjectile, (String)"poppedProjectile");
                return poppedProjectile;
            }
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }

        public static /* synthetic */ ItemStack popProjectile$default(Companion companion, ItemStack itemStack, int n, Slot slot, int n2, Object object) {
            if ((n2 & 4) != 0) {
                slot = null;
            }
            return companion.popProjectile(itemStack, n, slot);
        }

        @NotNull
        public final ItemStack peekProjectile(@NotNull ItemStack quiverStack, int countForPeek) {
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            if (this.isNotQuiverItem(quiverStack)) {
                ItemStack itemStack = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            QuiverItem quiverItem = (QuiverItem)item;
            ListTag listTag = this.getProjectilesListTag(quiverStack);
            if (listTag == null) {
                ItemStack itemStack = ItemStack.f_41583_;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            ListTag projectilesListTag = listTag;
            int n = 0;
            int n2 = projectilesListTag.size();
            ItemStack[] itemStackArray = new ItemStack[n2];
            while (n < n2) {
                int n3 = n++;
                itemStackArray[n3] = ItemStack.m_41712_((CompoundTag)projectilesListTag.m_128728_(n3));
            }
            ItemStack[] projectiles = itemStackArray;
            CompoundTag compoundTag = quiverStack.m_41783_();
            Intrinsics.checkNotNull((Object)compoundTag);
            byte selectedSlot = compoundTag.m_128445_(QuiverItem.NBT_SELECTED_SLOT_NAME);
            int n4 = quiverItem.getInventorySize();
            for (int i = 0; i < n4; ++i) {
                int iterIndex = Math.floorMod(selectedSlot - i, quiverItem.getInventorySize());
                ItemStack projectile = projectiles[iterIndex];
                if (projectile.m_41619_()) continue;
                int peekCount = Math.min(projectile.m_41741_(), countForPeek);
                ItemStack itemStack = projectile.m_255036_(peekCount);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"projectile.copyWithCount(peekCount)");
                return itemStack;
            }
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }

        public static /* synthetic */ ItemStack peekProjectile$default(Companion companion, ItemStack itemStack, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = Integer.MAX_VALUE;
            }
            return companion.peekProjectile(itemStack, n);
        }

        public final void selectSlot(@NotNull ItemStack quiverStack, int slotIndex) {
            boolean foundProjectile;
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            if (this.isNotQuiverItem(quiverStack)) {
                return;
            }
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            int inventorySize = ((QuiverItem)item).getInventorySize();
            ItemStack[] itemStackArray = this.getProjectiles(quiverStack);
            if (itemStackArray == null) {
                return;
            }
            ItemStack[] projectiles = itemStackArray;
            int resultSlotIndex = Math.max(Math.min(slotIndex, inventorySize - 1), 0);
            boolean bl = foundProjectile = !projectiles[resultSlotIndex].m_41619_();
            if (foundProjectile) {
                CompoundTag compoundTag = quiverStack.m_41783_();
                Intrinsics.checkNotNull((Object)compoundTag);
                compoundTag.m_128344_(QuiverItem.NBT_SELECTED_SLOT_NAME, (byte)resultSlotIndex);
            } else {
                this.selectFirstAvailableSlot(quiverStack, false);
            }
        }

        private final int selectFirstAvailableSlot(ItemStack quiverStack, boolean toRight) {
            boolean foundProjectile;
            if (this.isNotQuiverItem(quiverStack)) {
                return -1;
            }
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            int inventorySize = ((QuiverItem)item).getInventorySize();
            ItemStack[] itemStackArray = this.getProjectiles(quiverStack);
            if (itemStackArray == null) {
                return -1;
            }
            ItemStack[] projectiles = itemStackArray;
            CompoundTag compoundTag = quiverStack.m_41783_();
            Intrinsics.checkNotNull((Object)compoundTag);
            int selectedSlot = compoundTag.m_128445_(QuiverItem.NBT_SELECTED_SLOT_NAME);
            boolean bl = foundProjectile = !projectiles[selectedSlot].m_41619_();
            if (!foundProjectile) {
                for (int i = 1; i < inventorySize; ++i) {
                    int iterIndex = Math.floorMod(toRight ? selectedSlot + i : selectedSlot - i, inventorySize);
                    if (projectiles[iterIndex].m_41619_()) continue;
                    selectedSlot = iterIndex;
                    foundProjectile = true;
                    break;
                }
            }
            if (foundProjectile) {
                CompoundTag compoundTag2 = quiverStack.m_41783_();
                Intrinsics.checkNotNull((Object)compoundTag2);
                compoundTag2.m_128344_(QuiverItem.NBT_SELECTED_SLOT_NAME, (byte)selectedSlot);
                return selectedSlot;
            }
            CompoundTag compoundTag3 = quiverStack.m_41783_();
            Intrinsics.checkNotNull((Object)compoundTag3);
            compoundTag3.m_128344_(QuiverItem.NBT_SELECTED_SLOT_NAME, (byte)0);
            return -1;
        }

        private final void reinitNbt(ItemStack quiverStack) {
            CompoundTag tag = new CompoundTag();
            Item item = quiverStack.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.moddercoder.legendaryitems.item.QuiverItem");
            int inventorySize = ((QuiverItem)item).getInventorySize();
            CompoundTag stackTag = new CompoundTag();
            ItemStack.f_41583_.m_41739_(stackTag);
            ListTag listTag = new ListTag();
            for (int i = 0; i < inventorySize; ++i) {
                listTag.add(i, (Tag)stackTag.m_6426_());
            }
            tag.m_128365_(QuiverItem.NBT_PROJECTILES_INVENTORY_NAME, (Tag)listTag);
            tag.m_128344_(QuiverItem.NBT_SELECTED_SLOT_NAME, (byte)0);
            quiverStack.m_41751_(tag);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lnet/moddercoder/legendaryitems/item/QuiverItem$ItemStackObservable;", "Lnet/minecraft/world/item/ItemStack;", "item", "Lnet/minecraft/world/level/ItemLike;", "count", "", "quiverStack", "tag", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/nbt/CompoundTag;)V", "getQuiverStack", "()Lnet/minecraft/world/item/ItemStack;", "shrink", "", "legendaryitems-1.20.1"})
    public static final class ItemStackObservable
    extends ItemStack {
        @NotNull
        private final ItemStack quiverStack;

        public ItemStackObservable(@NotNull ItemLike item, int count, @NotNull ItemStack quiverStack, @Nullable CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)quiverStack, (String)"quiverStack");
            super(item, count, tag);
            this.quiverStack = quiverStack;
        }

        public /* synthetic */ ItemStackObservable(ItemLike itemLike, int n, ItemStack itemStack, CompoundTag compoundTag, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                compoundTag = null;
            }
            this(itemLike, n, itemStack, compoundTag);
        }

        @NotNull
        public final ItemStack getQuiverStack() {
            return this.quiverStack;
        }

        public void m_41774_(int count) {
            net.moddercoder.legendaryitems.item.QuiverItem$Companion.popProjectile$default(Companion, this.quiverStack, count, null, 4, null);
            super.m_41774_(count);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickAction.values().length];
            try {
                nArray[ClickAction.PRIMARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickAction.SECONDARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

