/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import sfiomn.legendarycreatures.config.Config;
import sfiomn.legendarycreatures.registry.ParticleTypeRegistry;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WispPurseEntity
extends Mob
implements GeoEntity {
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation FALL = RawAnimation.begin().thenPlay("fall");
    protected static final RawAnimation GROUND = RawAnimation.begin().thenPlayAndHold("ground");

    public WispPurseEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        List<Integer> xpRewardLimits = this.getRangeXp();
        int xpReward = 0;
        if (xpRewardLimits.size() == 1) {
            xpReward = xpRewardLimits.get(0);
        } else if (xpRewardLimits.size() > 1) {
            xpReward = Objects.equals(xpRewardLimits.get(0), xpRewardLimits.get(1)) ? xpRewardLimits.get(0) : Math.min(xpRewardLimits.get(0), xpRewardLimits.get(1)) + level.f_46441_.m_188503_(Math.abs(xpRewardLimits.get(0) - xpRewardLimits.get(1)));
        }
        this.f_21364_ = xpReward;
    }

    protected List<Integer> getRangeXp() {
        return Config.Baked.wispPurseXpReward;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.005).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "animController", 10, this::animPredicate)});
    }

    public <E extends GeoAnimatable> PlayState animPredicate(AnimationState<E> event) {
        if (this.m_20096_()) {
            event.getController().setAnimation(GROUND);
            if (event.getController().hasAnimationFinished()) {
                return PlayState.STOP;
            }
        } else {
            event.getController().setAnimation(FALL);
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        if (!this.m_20096_()) {
            RandomSource random = this.m_217043_();
            if (this.m_9236_().m_46467_() % 3L == 0L) {
                for (int i = 0; i < 3; ++i) {
                    double offsetX = (2.0f * random.m_188501_() - 1.0f) * 0.3f;
                    double offsetZ = (2.0f * random.m_188501_() - 1.0f) * 0.3f;
                    double x = this.m_20182_().f_82479_ + offsetX;
                    double y = this.m_20182_().f_82480_ + (double)(random.m_188501_() * 0.05f);
                    double z = this.m_20182_().f_82481_ + offsetZ;
                    if (this.m_9236_().m_46467_() % 3L != 0L) continue;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypeRegistry.WISP_PARTICLE.get(), x, y, z, offsetX / 10.0, 0.01, offsetZ / 10.0);
                }
            }
        }
        super.m_8119_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.WISP_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.WISP_DEATH.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }
}

