/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.ScorpionBabyEntity;
import sfiomn.legendarycreatures.entities.goals.BaseMeleeAttackGoal;
import sfiomn.legendarycreatures.entities.goals.PoisonMeleeAttackGoal;
import sfiomn.legendarycreatures.registry.EntityTypeRegistry;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ScorpionEntity
extends AnimatedCreatureEntity
implements Enemy {
    private final int baseAttackDuration = 16;
    private final int baseAttackActionPoint = 10;
    private final int tailAttackDuration = 20;
    private final int tailAttackActionPoint = 7;
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenPlay("run");
    private final RawAnimation CLAWS_ANIM = RawAnimation.begin().thenPlay("claws");
    private final RawAnimation TAIL_ANIM = RawAnimation.begin().thenPlay("tail");

    public ScorpionEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
        if (this.isLevel2()) {
            this.f_21364_ = 10;
        }
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        if (!this.m_9236_().f_46443_) {
            boolean hasBabies;
            boolean bl = hasBabies = this.m_217043_().m_188503_(100) >= 70;
            if (this.m_217043_().m_188503_(100) >= 90) {
                if (hasBabies) {
                    this.setVariant(8);
                } else {
                    this.setVariant(2);
                }
            } else if (hasBabies) {
                this.setVariant(7);
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        final PoisonMeleeAttackGoal poisonMeleeAttackGoal = new PoisonMeleeAttackGoal(this, 200, 0, 3, 20, 7, 5, 1.0, true, 200){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return ScorpionEntity.this.getMobLength() * 2.0f * ScorpionEntity.this.getMobLength() * 2.0f + entity.m_20205_();
            }

            @Override
            protected void executeAttack(LivingEntity target) {
                super.executeAttack(target);
                this.mob.m_5496_((SoundEvent)SoundRegistry.SCORPION_TAIL_ATTACK_HIT.get(), 1.0f, 1.0f);
            }
        };
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)poisonMeleeAttackGoal);
        this.f_21345_.m_25352_(4, (Goal)new BaseMeleeAttackGoal(this, 16, 10, 5, 1.0, true){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return ScorpionEntity.this.getMobLength() * 2.0f * ScorpionEntity.this.getMobLength() * 2.0f + entity.m_20205_();
            }

            @Override
            protected boolean executeAttack(LivingEntity target) {
                this.mob.m_5496_((SoundEvent)SoundRegistry.SCORPION_CLAWS_ATTACK_HIT.get(), 1.0f, 1.0f);
                return super.executeAttack(target);
            }

            @Override
            public boolean m_8045_() {
                if (poisonMeleeAttackGoal.m_8036_()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6, 40));
    }

    private float getMobLength() {
        return 1.5f;
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            return state.setAndContinue(this.CLAWS_ANIM);
        }
        if (this.getAttackAnimation() == 5) {
            return state.setAndContinue(this.TAIL_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag nbt) {
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackAttribute = this.m_21051_(Attributes.f_22281_);
        if (this.isLevel2()) {
            if (healthAttribute != null) {
                healthAttribute.m_22125_(new AttributeModifier(MAX_HEALTH_UUID, "legendarycreatures:scorpion_level2", healthAttribute.m_22115_() * 2.0, AttributeModifier.Operation.ADDITION));
                this.m_21153_(1000.0f);
            }
            if (attackAttribute != null) {
                attackAttribute.m_22125_(new AttributeModifier(ATTACK_DAMAGE_UUID, "legendarycreatures:scorpion_level2", attackAttribute.m_22115_() * 2.0, AttributeModifier.Operation.ADDITION));
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, nbt);
    }

    public Component m_7755_() {
        String descriptionId = "entity.legendarycreatures.scorpion";
        if (this.isLevel2()) {
            descriptionId = "entity.legendarycreatures.scorpion2";
        }
        return Component.m_237115_((String)descriptionId);
    }

    public boolean isLevel2() {
        return this.getVariant() == 2 || this.getVariant() == 8;
    }

    @Override
    public RawAnimation getSprintAnimation() {
        return this.RUN_ANIM;
    }

    public boolean hasBabies() {
        return this.getVariant() >= 7;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(@NotNull Pose p_21131_, @NotNull EntityDimensions p_21132_) {
        return 0.35f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.SCORPION_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.SCORPION_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundRegistry.SCORPION_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SoundRegistry.SCORPION_STEP.get(), 1.0f, 1.0f);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.m_21224_() && !this.m_213877_() && this.hasBabies()) {
            int nbBabies = 1 + this.f_19796_.m_188503_(3);
            for (int l = 0; l < nbBabies; ++l) {
                float f1 = (float)(l % 2) - 0.5f;
                float f2 = (float)(l / 2) - 0.5f;
                ScorpionBabyEntity scorpionBabyEntity = (ScorpionBabyEntity)((EntityType)EntityTypeRegistry.SCORPION_BABY.get()).m_20615_(this.m_9236_());
                if (scorpionBabyEntity == null) {
                    return;
                }
                if (this.m_21532_()) {
                    scorpionBabyEntity.m_21530_();
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12422_, SoundSource.HOSTILE, 10.0f, 1.0f);
                scorpionBabyEntity.m_20331_(this.m_20147_());
                if (this.isLevel2()) {
                    scorpionBabyEntity.setVariant(2);
                }
                scorpionBabyEntity.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 0.5, this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)scorpionBabyEntity);
            }
        }
        super.m_142687_(reason);
    }

    protected ResourceLocation m_7582_() {
        if (this.isLevel2()) {
            return new ResourceLocation("legendarycreatures", "entities/scorpion_level2");
        }
        return super.m_7582_();
    }
}

