/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.api.network.IClientEventEntity;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEntityEvent<T extends Entity> {
    private final int entityId;
    private final byte eventId;

    public ClientboundEntityEvent(Entity pEntity, byte pEventId) {
        this.entityId = pEntity.m_19879_();
        this.eventId = pEventId;
    }

    public ClientboundEntityEvent(FriendlyByteBuf pBuffer) {
        this.entityId = pBuffer.readInt();
        this.eventId = pBuffer.readByte();
    }

    public void toBytes(FriendlyByteBuf pBuffer) {
        pBuffer.writeInt(this.entityId);
        pBuffer.writeByte((int)this.eventId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> MinecraftInstanceHelper.ifPlayerPresent(player -> {
            Entity patt1341$temp = this.getEntity(player.f_19853_);
            if (patt1341$temp instanceof IClientEventEntity) {
                IClientEventEntity entity = (IClientEventEntity)patt1341$temp;
                entity.handleClientEvent(this.eventId);
            }
        }));
        return true;
    }

    @Nullable
    public Entity getEntity(Level pLevel) {
        return pLevel.m_6815_(this.entityId);
    }

    public byte getEventId() {
        return this.eventId;
    }
}

