/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.ray_of_frost;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.ray_of_frost.RayOfFrostVisualEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RayOfFrostRenderer
extends EntityRenderer<RayOfFrostVisualEntity> {
    public static final ModelLayerLocation MODEL_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("irons_spellbooks", "ray_of_frost_model"), "main");
    private static final ResourceLocation TEXTURE_CORE = IronsSpellbooks.id("textures/entity/ray_of_frost/core.png");
    private static final ResourceLocation TEXTURE_OVERLAY = IronsSpellbooks.id("textures/entity/ray_of_frost/overlay.png");
    private final ModelPart body;

    public RayOfFrostRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(MODEL_LAYER_LOCATION);
        this.body = modelpart.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -16.0f, -8.0f, 16.0f, 32.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public boolean shouldRender(RayOfFrostVisualEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    public void render(RayOfFrostVisualEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        float lifetime = 15.0f;
        float scalar = 0.25f;
        float length = 32.0f * scalar * scalar;
        float f = (float)entity.f_19797_ + partialTicks;
        poseStack.m_85837_(0.0, entity.m_20191_().m_82376_() * 0.5, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_() - 180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-entity.m_146909_() - 90.0f));
        poseStack.m_85841_(scalar, scalar, scalar);
        float alpha = Mth.m_14036_((float)(1.0f - f / lifetime), (float)0.0f, (float)1.0f);
        for (float i = 0.0f; i < entity.distance * 4.0f; i += length) {
            poseStack.m_252880_(0.0f, length, 0.0f);
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)TEXTURE_OVERLAY, (float)0.0f, (float)0.0f));
            poseStack.m_85836_();
            float expansion = Mth.m_144920_((float)1.2f, (float)0.0f, (float)(f / lifetime));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f * 5.0f));
            poseStack.m_85841_(expansion, 1.0f, expansion);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            this.body.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            poseStack.m_85849_();
            consumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)TEXTURE_CORE, (float)0.0f, (float)0.0f));
            poseStack.m_85836_();
            expansion = Mth.m_144920_((float)1.0f, (float)0.0f, (float)(f / (lifetime - 8.0f)));
            poseStack.m_85841_(expansion, 1.0f, expansion);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f * -10.0f));
            this.body.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(RayOfFrostVisualEntity entity) {
        return TEXTURE_CORE;
    }
}

