/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.TextureSprite;
import com.samsthenerd.inline.utils.URLSprite;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public abstract class Spritelike {
    private static final Map<String, SpritelikeType> TYPES = new HashMap<String, SpritelikeType>();
    private static final Codec<SpritelikeType> TYPE_CODEC;
    public static final Codec<Spritelike> CODEC;

    public abstract SpritelikeType getType();

    @Nullable
    public abstract ResourceLocation getTextureId();

    public abstract SpriteUVRegion getUVs(long var1);

    public SpriteUVRegion getUVs() {
        return this.getUVs(SpriteUVLens.getSysTime());
    }

    public abstract int getTextureWidth();

    public abstract int getTextureHeight();

    public static Spritelike fromJson(JsonElement json) {
        return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(error -> {}).orElse(null);
    }

    public static Spritelike fromNbt(Tag nbt) {
        return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(error -> {}).orElse(null);
    }

    public static void registerType(SpritelikeType type) {
        TYPES.put(type.getId(), type);
    }

    static {
        Spritelike.registerType(URLSprite.UrlSpriteType.INSTANCE);
        Spritelike.registerType(TextureSprite.TextureSpriteType.INSTANCE);
        TYPE_CODEC = Codec.STRING.comapFlatMap(id -> {
            SpritelikeType type = TYPES.get(id);
            if (type == null) {
                return DataResult.error(() -> "Unknown spritelike type: " + id);
            }
            return DataResult.success((Object)type);
        }, SpritelikeType::getId);
        CODEC = TYPE_CODEC.dispatch("type", Spritelike::getType, SpritelikeType::getCodec);
    }

    public static interface SpritelikeType {
        public Codec<? extends Spritelike> getCodec();

        public String getId();

        public static SpritelikeType of(String id, Codec<Spritelike> codec) {
            return new Simple(id, codec);
        }

        public static class Simple
        implements SpritelikeType {
            private final String id;
            private final Codec<Spritelike> codec;

            public Simple(String id, Codec<Spritelike> codec) {
                this.id = id;
                this.codec = codec;
            }

            public Codec<Spritelike> getCodec() {
                return this.codec;
            }

            @Override
            public String getId() {
                return this.id;
            }
        }
    }
}

