/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips.providers;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.xplat.IModMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.NotNull;

public class ModDataTTProvider
implements CustomTooltipManager.CustomTooltipProvider<IModMeta> {
    public static final ModDataTTProvider INSTANCE = new ModDataTTProvider();

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("inline", "moddata");
    }

    @Override
    @NotNull
    public List<Component> getTooltipText(IModMeta mod) {
        ArrayList<Component> modInfo = new ArrayList<Component>();
        if (mod == null) {
            return modInfo;
        }
        MutableComponent title = Component.m_237113_((String)mod.getName()).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        MutableComponent description = Component.m_237113_((String)mod.getDescription().replace("\n", "")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
        modInfo.add((Component)title);
        modInfo.add((Component)description);
        return modInfo;
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipData(IModMeta mod) {
        if (mod == null) {
            return Optional.empty();
        }
        Spritelike iconSprite = ModIconData.spriteFromModid(mod.getModId(), false);
        if (iconSprite == null) {
            return Optional.empty();
        }
        return Optional.of(new SpriteTooltipData(iconSprite, (w, h) -> 32));
    }

    @Override
    @NotNull
    public Codec<IModMeta> getCodec() {
        return Codec.STRING.xmap(modid -> IModMeta.getMod(modid).orElse(null), IModMeta::getModId);
    }
}

