/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.ModDataTTProvider;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.TextureSprite;
import com.samsthenerd.inline.utils.URLSprite;
import com.samsthenerd.inline.xplat.IModMeta;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class ModIconData
extends SpriteInlineData {
    public static final Spritelike MISSING_ICON = new TextureSprite(new ResourceLocation("inline", "textures/missingicon.png"));
    public String modid;

    @Override
    public ModIconDataType getType() {
        return ModIconDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId() {
        return new ResourceLocation("inline", "spritelike");
    }

    public ModIconData(String modid) {
        this(modid, true);
    }

    public ModIconData(String modid, boolean usePlaceholder) {
        super(ModIconData.spriteFromModid(modid, usePlaceholder));
        this.modid = modid;
    }

    @Nullable
    public static Spritelike spriteFromModid(String modid, boolean usePlaceholder) {
        Optional<IModMeta> maybeMod = IModMeta.getMod(modid);
        if (maybeMod.isEmpty()) {
            return usePlaceholder ? MISSING_ICON : null;
        }
        IModMeta mod = maybeMod.get();
        try {
            Optional<String> logoFile = mod.getLogoFile(128);
            if (logoFile.isEmpty()) {
                return usePlaceholder ? MISSING_ICON : null;
            }
            Optional<Path> logoPath = mod.findResource(logoFile.get());
            if (logoPath.isEmpty()) {
                return usePlaceholder ? MISSING_ICON : null;
            }
            return new URLSprite(logoPath.get().toUri().toURL().toString(), new ResourceLocation("inlinemodicon", mod.getModId()));
        }
        catch (Exception e) {
            return usePlaceholder ? MISSING_ICON : null;
        }
    }

    public static Style getTooltipStyle(String modid) {
        Optional<IModMeta> maybeMod = IModMeta.getMod(modid);
        if (maybeMod.isEmpty()) {
            return Style.f_131099_;
        }
        IModMeta mod = maybeMod.get();
        HoverEvent he = new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(CustomTooltipManager.getForTooltip(ModDataTTProvider.INSTANCE, mod)));
        Style styled = Style.f_131099_.m_131144_(he);
        Optional<String> homepageMaybe = mod.getHomepage();
        if (homepageMaybe.isPresent()) {
            ClickEvent ce = new ClickEvent(ClickEvent.Action.OPEN_URL, homepageMaybe.get().toString());
            styled = styled.m_131142_(ce);
        }
        return styled;
    }

    public static Component makeModIcon(IModMeta mod) {
        Style dataStyle = InlineStyle.fromInlineData(new ModIconData(mod.getModId()));
        return Component.m_237113_((String)".").m_6270_(dataStyle.m_131146_(ModIconData.getTooltipStyle(mod.getModId())));
    }

    public static class ModIconDataType
    extends SpriteInlineData.SpriteDataType {
        public static ModIconDataType INSTANCE = new ModIconDataType();

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("inline", "modicon");
        }

        @Override
        public Codec<SpriteInlineData> getCodec() {
            return Codec.STRING.flatComapMap(ModIconData::new, data -> {
                if (!(data instanceof ModIconData)) {
                    return DataResult.error(() -> "");
                }
                ModIconData mData = (ModIconData)data;
                return DataResult.success((Object)mData.modid);
            });
        }
    }
}

