/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.reference;

import net.fabricmc.loader.api.FabricLoader;

public class Reference {
    public static final VersionType PRODUCTION_VERSION_TYPE = VersionType.DIAMOND;
    public static final VersionTypeWrapper VERSION_TYPE = new VersionTypeWrapper(FabricLoader.getInstance().isDevelopmentEnvironment() ? Reference.getVersionTypeByString(String.valueOf(System.getProperty("immortalsoul.versionType", "iron"))) : PRODUCTION_VERSION_TYPE);
    public static final String VERSION = "1.1.3.2";
    public static final String MODID = "immortalsoul";
    public static final String AUTHOR = "ModderCoder";

    private static VersionType getVersionTypeByString(String value) {
        return switch (value.trim().toLowerCase()) {
            case "gold" -> VersionType.GOLD;
            case "diamond" -> VersionType.DIAMOND;
            default -> VersionType.IRON;
        };
    }

    private static enum VersionType {
        IRON,
        GOLD,
        DIAMOND;


        public boolean isGold() {
            return this.ordinal() > 0;
        }

        public boolean isDiamond() {
            return this.ordinal() > 1;
        }
    }

    public static class VersionTypeWrapper {
        private VersionType versionType;

        public VersionTypeWrapper(VersionType versionType) {
            this.versionType = versionType;
        }

        public boolean isGold() {
            return this.versionType.isGold();
        }

        public boolean isDiamond() {
            return this.versionType.isDiamond();
        }

        public boolean isOnlyGold() {
            return !this.isDiamond() && this.isGold();
        }
    }
}

