/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.item;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5321;
import net.moddercoder.immortalsoul.block.WaystoneBlock;
import net.moddercoder.immortalsoul.item.IAttackBarVisualizedItem;
import org.jetbrains.annotations.Nullable;

public class ScrollReturnItem
extends class_1792
implements IAttackBarVisualizedItem {
    public static final String SUB_NBT_WAYSTONE_DATA_NAME = "WaystoneData";
    public static final String NBT_RETURN_POS_NAME = "ReturnPos";
    public static final String NBT_WAYSTONE_POS_NAME = "WaystonePos";
    public static final String NBT_DIMENSION_NAME = "Dimension";
    public static final int USAGE_DURATION = 100;
    public static final int CREATIVE_USAGE_DURATION = 20;

    protected static boolean validForNbt(class_1799 stack) {
        return stack.method_7909() instanceof ScrollReturnItem;
    }

    public static boolean hasJoinedToWaystone(class_1799 stack) {
        if (!ScrollReturnItem.validForNbt(stack)) {
            return false;
        }
        class_2487 nbt = stack.method_7941(SUB_NBT_WAYSTONE_DATA_NAME);
        return nbt != null && !nbt.method_33133();
    }

    @Nullable
    public static class_2487 getWaystoneNbt(class_1799 stack) {
        if (!ScrollReturnItem.validForNbt(stack) || !ScrollReturnItem.hasJoinedToWaystone(stack)) {
            return null;
        }
        return stack.method_7941(SUB_NBT_WAYSTONE_DATA_NAME);
    }

    public static boolean joinToWaystone(class_1799 stack, class_2338 returnBlockPos, class_2338 waystoneBlockPos, class_5321<class_1937> dimension) {
        if (!ScrollReturnItem.validForNbt(stack)) {
            return false;
        }
        class_2487 nbt = stack.method_7911(SUB_NBT_WAYSTONE_DATA_NAME);
        nbt.method_10544(NBT_RETURN_POS_NAME, returnBlockPos.method_10063());
        nbt.method_10544(NBT_WAYSTONE_POS_NAME, waystoneBlockPos.method_10063());
        nbt.method_10582(NBT_DIMENSION_NAME, dimension.method_29177().toString());
        return true;
    }

    public static void removeFromWaystone(class_1799 stack) {
        if (!ScrollReturnItem.validForNbt(stack)) {
            return;
        }
        stack.method_7959(SUB_NBT_WAYSTONE_DATA_NAME, (class_2520)new class_2487());
    }

    public ScrollReturnItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (ScrollReturnItem.hasJoinedToWaystone(stack)) {
            user.method_7350();
            user.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_2338 waystoneBlockPos = context.method_8037();
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        if (!ScrollReturnItem.hasJoinedToWaystone(stack) && world.method_8320(waystoneBlockPos).method_26204() instanceof WaystoneBlock && ScrollReturnItem.joinToWaystone(stack, player.method_24515(), waystoneBlockPos, (class_5321<class_1937>)world.method_27983())) {
            player.method_5783(class_3417.field_14627, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)true);
        }
        return super.method_7884(context);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 userPlayer = (class_1657)user;
            int usedTicks = this.method_7881(stack) - remainingUseTicks;
            if (usedTicks == this.getUsageDuration(userPlayer)) {
                userPlayer.method_5783(class_3417.field_14627, 1.0f, 1.0f);
            }
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1657 userPlayer;
        int usedTicks = this.method_7881(stack) - remainingUseTicks;
        if (user instanceof class_1657 && usedTicks >= this.getUsageDuration(userPlayer = (class_1657)user)) {
            boolean triggerAfterNonCreativeScrollUsedEvent = false;
            if (ScrollReturnItem.hasJoinedToWaystone(stack)) {
                class_2487 waystoneNbt = ScrollReturnItem.getWaystoneNbt(stack);
                if (waystoneNbt != null) {
                    class_2338 returnBlockPos = class_2338.method_10092((long)waystoneNbt.method_10537(NBT_RETURN_POS_NAME));
                    String dimensionName = waystoneNbt.method_10558(NBT_DIMENSION_NAME);
                    if (!world.field_9236) {
                        class_1937 teleportedWorld = null;
                        boolean matchDimension = false;
                        for (class_1937 iterWorld : ((class_3218)world).method_8503().method_3738()) {
                            if (!iterWorld.method_27983().method_29177().toString().equals(dimensionName)) continue;
                            teleportedWorld = iterWorld;
                            matchDimension = true;
                            break;
                        }
                        if (matchDimension) {
                            class_2338 waystoneBlockPos = class_2338.method_10092((long)waystoneNbt.method_10537(NBT_WAYSTONE_POS_NAME));
                            class_5321 teleportedWorldRegistryKey = teleportedWorld.method_27983();
                            if (teleportedWorldRegistryKey != user.method_37908().method_27983()) {
                                userPlayer.method_7353((class_2561)class_2561.method_43469((String)"text.scroll_return.unable_teleport.another_dimension", (Object[])new Object[]{teleportedWorldRegistryKey.method_29177()}).method_27692(class_124.field_1061), true);
                                world.method_8396(null, user.method_24515(), class_3417.field_15081, class_3419.field_15248, 1.0f, 0.1f);
                            } else if (!(world.method_8320(waystoneBlockPos).method_26204() instanceof WaystoneBlock)) {
                                ScrollReturnItem.removeFromWaystone(stack);
                                userPlayer.method_7353((class_2561)class_2561.method_43469((String)"text.scroll_return.unable_teleport.cant_find_waystone", (Object[])new Object[]{teleportedWorldRegistryKey.method_29177()}).method_27692(class_124.field_1061), true);
                                world.method_8396(null, user.method_24515(), class_3417.field_15081, class_3419.field_15248, 1.0f, 0.1f);
                            } else {
                                user.method_20620((double)returnBlockPos.method_10263() + 0.5, (double)returnBlockPos.method_10264() + 0.5, (double)returnBlockPos.method_10260() + 0.5);
                                userPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
                                world.method_45447(null, user.method_24515(), class_3417.field_15210, class_3419.field_15248);
                                triggerAfterNonCreativeScrollUsedEvent = true;
                            }
                        } else {
                            ScrollReturnItem.removeFromWaystone(stack);
                            userPlayer.method_7353((class_2561)class_2561.method_43469((String)"text.scroll_return.unable_teleport.unknown_dimension", (Object[])new Object[]{dimensionName}).method_27692(class_124.field_1061), true);
                            world.method_8396(null, user.method_24515(), class_3417.field_15081, class_3419.field_15248, 1.0f, 0.1f);
                        }
                    }
                }
                if (!userPlayer.method_31549().field_7477 && triggerAfterNonCreativeScrollUsedEvent) {
                    this.afterNonCreativeScrollUsed(stack, userPlayer);
                }
            }
        }
    }

    protected void afterNonCreativeScrollUsed(class_1799 stack, class_1657 user) {
        stack.method_7934(1);
    }

    @Override
    public int getUsageAttackBarDuration(class_1657 usagePlayer) {
        return this.getUsageDuration(usagePlayer);
    }

    protected int getUsageDuration(class_1657 usagePlayer) {
        return usagePlayer.method_7337() ? 20 : 100;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }
}

