/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.gold.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3468;
import net.minecraft.class_5134;
import net.minecraft.class_5150;
import net.moddercoder.immortalsoul.gold.entity.CursedAxeProjectileEntity;
import net.moddercoder.immortalsoul.gold.sound.ModSoundEventsGold;
import net.moddercoder.immortalsoul.item.ModItems;
import net.moddercoder.immortalsoul.item.ModItemsGold;
import net.moddercoder.immortalsoul.mixinexpander.ILivingEntityForCursedAxeExpander;

public class CursedAxeItem
extends class_1792
implements class_5150 {
    public static final int RESET_POWERFUL_ATTACK_DURATION = 100;
    public static final int ATTACK_COUNT_FOR_POWERFUL = 3;
    public static final int THROW_RELOADING_TICKS = 600;
    public static final int DAMAGE_COOLDOWN_TICKS = 10;
    public static final String NBT_HIT_COUNT_NAME = "HitCount";
    public static final String NBT_IS_FULL_CURSED_SET_NAME = "IsFullCursedSet";
    private final int attackDamage;
    private final float attackSpeed;
    private final Multimap<class_1320, class_1322> attributeModifiers;
    private final Multimap<class_1320, class_1322> attributeModifiersWithFullArmorSet;

    public static boolean incrementHitCount(class_1799 stack) {
        if (!stack.method_31574(ModItemsGold.CURSED_AXE)) {
            return false;
        }
        class_2487 nbt = stack.method_7948();
        boolean powerfulAttack = false;
        int hitCount = 1;
        if (!nbt.method_33133() && (hitCount = nbt.method_10550(NBT_HIT_COUNT_NAME) + 1) >= 3) {
            powerfulAttack = true;
            hitCount = 0;
        }
        nbt.method_10569(NBT_HIT_COUNT_NAME, hitCount);
        return powerfulAttack;
    }

    public static void resetHitCount(class_1799 stack) {
        if (!stack.method_31574(ModItemsGold.CURSED_AXE)) {
            return;
        }
        class_2487 nbt = stack.method_7948();
        nbt.method_10569(NBT_HIT_COUNT_NAME, 0);
    }

    public static int getHitCount(class_1799 stack) {
        if (!stack.method_31574(ModItemsGold.CURSED_AXE)) {
            return -1;
        }
        class_2487 nbt = stack.method_7948();
        return nbt.method_10550(NBT_HIT_COUNT_NAME);
    }

    public static void setFullCursedSetNbt(class_1799 stack, boolean value) {
        if (!stack.method_31574(ModItemsGold.CURSED_AXE)) {
            return;
        }
        class_2487 nbt = stack.method_7948();
        nbt.method_10556(NBT_IS_FULL_CURSED_SET_NAME, value);
    }

    public static boolean isFullCursedSetNbt(class_1799 stack) {
        if (!stack.method_31574(ModItemsGold.CURSED_AXE)) {
            return false;
        }
        class_2487 nbt = stack.method_7948();
        return nbt.method_10577(NBT_IS_FULL_CURSED_SET_NAME);
    }

    public CursedAxeItem(int attackDamage, float attackSpeed, int maxUses, class_1792.class_1793 settings) {
        super(settings.method_7895(maxUses));
        this.attackSpeed = attackSpeed;
        this.attackDamage = attackDamage;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
        builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", (double)(this.attackSpeed + 0.6f), class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        this.attributeModifiersWithFullArmorSet = builder.build();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)user;
        int usageTicks = this.method_7881(stack) - remainingUseTicks;
        if (usageTicks < 5) {
            return;
        }
        if (!world.field_9236) {
            stack.method_7956(1, user, _user -> _user.method_20236(_user.method_6058()));
            CursedAxeProjectileEntity projectileEntity = new CursedAxeProjectileEntity(user, world);
            projectileEntity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 2.5f, 1.0f);
            if (playerEntity.method_31549().field_7477) {
                projectileEntity.field_7572 = class_1665.class_1666.field_7594;
            }
            if (world.method_8649((class_1297)projectileEntity)) {
                projectileEntity.method_5783(ModSoundEventsGold.CURSED_AXE_SPIN, 1.0f, 1.0f);
                if (!playerEntity.method_31549().field_7477) {
                    playerEntity.method_7357().method_7906((class_1792)this, 600);
                }
            }
        }
        playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1309) {
            ILivingEntityForCursedAxeExpander livingEntityForCursedAxeExpander;
            int resetPowerfulAttackTicks;
            boolean fullSetCursedArmor;
            class_1309 livingEntity = (class_1309)entity;
            if (world.field_9236 && livingEntity.method_6047().method_31574((class_1792)this) && CursedAxeItem.getHitCount(stack) + 1 >= 3) {
                for (int i = 0; i < 4; ++i) {
                    world.method_8406((class_2394)class_2398.field_11251, livingEntity.method_23322(1.0), livingEntity.method_23323(world.field_9229.method_43058() * 0.5), livingEntity.method_23325(1.0), 0.0, 0.0, 0.0);
                }
            }
            boolean bl = fullSetCursedArmor = livingEntity.method_6118(class_1304.field_6169).method_31574(ModItems.CURSED_HELMET) && livingEntity.method_6118(class_1304.field_6174).method_31574(ModItems.CURSED_CHESTPLATE) && livingEntity.method_6118(class_1304.field_6172).method_31574(ModItems.CURSED_LEGGINGS) && livingEntity.method_6118(class_1304.field_6166).method_31574(ModItems.CURSED_BOOTS);
            if (CursedAxeItem.isFullCursedSetNbt(stack) != fullSetCursedArmor) {
                CursedAxeItem.setFullCursedSetNbt(stack, fullSetCursedArmor);
            }
            if ((resetPowerfulAttackTicks = (livingEntityForCursedAxeExpander = (ILivingEntityForCursedAxeExpander)livingEntity).getResetPowerfulAttackTicks()) > 0) {
                livingEntityForCursedAxeExpander.setResetPowerfulAttackTicks(resetPowerfulAttackTicks - 1);
                if (livingEntityForCursedAxeExpander.getResetPowerfulAttackTicks() <= 0) {
                    CursedAxeItem.resetHitCount(stack);
                }
            }
        }
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.field_9236 && state.method_26214((class_1922)world, pos) != 0.0f) {
            stack.method_7956(1, miner, _entity -> _entity.method_20235(class_1304.field_6173));
        }
        return true;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173) {
            if (!CursedAxeItem.isFullCursedSetNbt(stack)) {
                return this.attributeModifiers;
            }
            return this.attributeModifiersWithFullArmorSet;
        }
        return super.getAttributeModifiers(stack, slot);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (CursedAxeItem.incrementHitCount(stack)) {
            ((ILivingEntityForCursedAxeExpander)attacker).setResetPowerfulAttackTicks(0);
            target.method_6092(new class_1293(class_1294.field_5920, 100, 0));
            target.method_5783(ModSoundEventsGold.CURSED_AXE_SLASH, 1.0f, 1.0f);
        } else {
            ((ILivingEntityForCursedAxeExpander)attacker).resetResetPowerfulAttackTicks();
        }
        stack.method_7956(1, attacker, _entity -> _entity.method_20235(class_1304.field_6173));
        return true;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(ModItems.CURSED_RELIC);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public int method_7837() {
        return 15;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public int getAttackDamage() {
        return this.attackDamage;
    }
}

