/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_8111;
import net.moddercoder.immortalsoul.item.CursedArmorItem;
import net.moddercoder.immortalsoul.item.ModItems;
import net.moddercoder.immortalsoul.mixin.LivingEntityInvoker;
import net.moddercoder.immortalsoul.register.IImmortalSoulRegister;
import org.apache.commons.lang3.ArrayUtils;

public class ModEvents
implements IImmortalSoulRegister {
    @Override
    public void registerAll() {
        this.registerHostilesSoulDrops();
        this.registerCursedArmorEvents();
        this.registerLootTableEvents();
        this.registerVillagerTrades();
    }

    protected void registerHostilesSoulDrops() {
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            class_1297 patt0$temp;
            if (livingEntity instanceof class_1588 && (patt0$temp = damageSource.method_5529()) instanceof class_1657) {
                class_1657 playerEntity = (class_1657)patt0$temp;
                if (damageSource.method_49708(class_8111.field_42320) && playerEntity.method_6047().method_31574(ModItems.SCYTHE_REAPER)) {
                    class_1937 world = playerEntity.method_5770();
                    int chance = world.field_9229.method_39332(0, 4);
                    if (chance < 2 && ((LivingEntityInvoker)livingEntity).invokeShouldDropLoot() && world.method_8450().method_8355(class_1928.field_19391)) {
                        livingEntity.method_5775(ModItems.SOUL.method_7854());
                    }
                }
            }
        });
    }

    protected void registerCursedArmorEvents() {
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            class_1297 patt0$temp;
            if (livingEntity instanceof class_1588 && (patt0$temp = damageSource.method_5529()) instanceof class_1657) {
                class_1657 playerEntity = (class_1657)patt0$temp;
                if (damageSource.method_49708(class_8111.field_42320) && CursedArmorItem.isFullSet((class_1309)playerEntity)) {
                    playerEntity.method_6025(4.0f);
                    playerEntity.method_6092(new class_1293(class_1294.field_5903, 260, 2, false, false, true));
                }
            }
        });
    }

    protected void registerLootTableEvents() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            class_55.class_56 lootPoolBuilder;
            String lootTableIdPath = id.method_12832();
            if (source.isBuiltin() && class_2246.field_10260.method_26162().equals((Object)id)) {
                lootPoolBuilder = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.SOUL));
                tableBuilder.pool(lootPoolBuilder.method_355());
            }
            if (!id.method_12836().equals("immortalsoul") && !lootTableIdPath.contains("/village/") && lootTableIdPath.contains("chests")) {
                lootPoolBuilder = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.OMINOUS_FRAGMENT_KEY).method_437(3)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8162).method_437(7));
                tableBuilder.pool(lootPoolBuilder.method_355());
            }
        });
    }

    protected void registerVillagerTrades() {
        ModEvents.registerVillagerOffers(class_3852.field_17055, 1, (List<class_3853.class_1652> factories) -> factories.add((entity, random) -> new class_1914(new class_1799((class_1935)class_1802.field_8687, 32), new class_1799((class_1935)class_1802.field_8463, 1), ModItems.KEY.method_7854(), 1, 7, 0.1f)));
    }

    protected static void registerVillagerOffers(class_3852 profession, int level, Consumer<List<class_3853.class_1652>> factory) {
        Objects.requireNonNull(profession, "VillagerProfession may not be null.");
        ModEvents.registerVillagerOffers((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17067.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap()), level, factory);
    }

    private static void registerVillagerOffers(Int2ObjectMap<class_3853.class_1652[]> leveledTradeMap, int level, Consumer<List<class_3853.class_1652>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] originalEntries = (class_3853.class_1652[])leveledTradeMap.computeIfAbsent(level, key -> new class_3853.class_1652[0]);
        Object[] addedEntries = list.toArray(new class_3853.class_1652[0]);
        class_3853.class_1652[] allEntries = (class_3853.class_1652[])ArrayUtils.addAll((Object[])originalEntries, (Object[])addedEntries);
        leveledTradeMap.put(level, (Object)allEntries);
    }
}

