/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.diamond.block.entity;

import java.util.ArrayList;
import java.util.function.Predicate;
import mod.azure.azurelib.animatable.GeoBlockEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6032;
import net.moddercoder.immortalsoul.diamond.block.CursedChestBlock;
import net.moddercoder.immortalsoul.diamond.block.entity.ModBlockEntityTypesDiamond;
import net.moddercoder.immortalsoul.diamond.config.ModConfigsDiamond;
import net.moddercoder.immortalsoul.diamond.config.ModGameplayConfig;
import net.moddercoder.immortalsoul.item.WeightedItemStack;
import org.jetbrains.annotations.Nullable;

public class CursedChestBlockEntity
extends class_2586
implements GeoBlockEntity {
    public static final int RELOADING_TICKS_DURATION = 24;
    public static final String NBT_AVAILABLE_ITEMS_NAME = "AvailableItems";
    public static final String NBT_DROPPED_ITEMS_COUNT_NAME = "DroppedItemCount";
    private final AnimatableInstanceCache animatableInstanceCache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation ANIMATION_OPEN = RawAnimation.begin().thenPlay("open");
    private WeightedItemStack[] availableItems;
    private int droppedItemCount;
    private int reloadingTicks = 0;

    public static void putWeightedItemStackArray(class_2487 nbt, String name, WeightedItemStack[] items) {
        class_2499 itemsNbtList = new class_2499();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                class_2487 itemNbt = items[i].writeNbt(new class_2487());
                itemsNbtList.add((Object)itemNbt);
            }
        }
        nbt.method_10566(name, (class_2520)itemsNbtList);
    }

    @Nullable
    public static WeightedItemStack[] getWeightedItemStackArray(class_2487 nbt, String name) {
        if (nbt.method_10573(name, 9)) {
            class_2499 itemsNbtList = nbt.method_10554(name, 10);
            WeightedItemStack[] items = new WeightedItemStack[itemsNbtList.size()];
            for (int i = 0; i < itemsNbtList.size(); ++i) {
                WeightedItemStack item;
                items[i] = item = WeightedItemStack.readNbt(itemsNbtList.method_10602(i));
            }
            return items;
        }
        return null;
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, CursedChestBlockEntity cursedChestBlockEntity) {
        cursedChestBlockEntity.tick(world, blockPos, blockState);
    }

    public CursedChestBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypesDiamond.CURSED_CHEST, pos, state);
        ModGameplayConfig gameplayConfig = ModConfigsDiamond.GAMEPLAY_CONFIG;
        if (gameplayConfig != null) {
            this.availableItems = (WeightedItemStack[])gameplayConfig.cursedChestItems().toArray(WeightedItemStack[]::new);
            this.droppedItemCount = gameplayConfig.cursedChestItemDroppedCount();
        }
    }

    public void tick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        if (this.isReloading()) {
            --this.reloadingTicks;
            if (!this.isReloading()) {
                this.afterReloading(world, blockPos, blockState);
            }
        }
    }

    public boolean open(class_1937 world, class_2338 pos, class_2680 state) {
        if (!this.isReloading()) {
            if (!world.field_9236) {
                for (class_1799 droppedItemStack : this.shuffleItems()) {
                    this.summonRewardItem(droppedItemStack, world, pos, state);
                }
                this.triggerAnim("controller", "open");
            }
            this.toggleReloading(false);
            return true;
        }
        return false;
    }

    public void afterReloading(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        world.method_8501(blockPos, class_2246.field_10124.method_9564());
        world.method_45447(null, blockPos, class_3417.field_15210, class_3419.field_15245);
    }

    protected void summonRewardItem(class_1799 droppedItemStack, class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236 && droppedItemStack != null && !droppedItemStack.method_7960()) {
            class_2382 facingVector = ((class_2350)state.method_11654((class_2769)CursedChestBlock.FACING)).method_10163();
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5 + (double)facingVector.method_10263() * 0.25, (double)pos.method_10264() - 0.25, (double)pos.method_10260() + 0.5 + (double)facingVector.method_10260() * 0.25, droppedItemStack, (double)facingVector.method_10263() * 0.05, 0.2, (double)facingVector.method_10260() * 0.05);
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
            for (int i = 0; i < 4; ++i) {
                ((class_3218)world).method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 1, 0.25, 0.3, 0.25, 0.0);
            }
        }
    }

    public class_1799[] shuffleItems() {
        ArrayList<class_1799> resultItemStacks = new ArrayList<class_1799>(this.getDroppedItemCount());
        class_6032 weightedItemStackGroupWeightedList = new class_6032();
        for (WeightedItemStack weightedItemStack : this.availableItems) {
            weightedItemStackGroupWeightedList.method_35093((Object)weightedItemStack.itemStack().method_7972(), weightedItemStack.weight());
        }
        resultItemStacks.addAll(weightedItemStackGroupWeightedList.method_35088().method_35094().toList().subList(0, this.getDroppedItemCount()).stream().filter(Predicate.not(class_1799::method_7960)).toList());
        return (class_1799[])resultItemStacks.toArray(class_1799[]::new);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(NBT_DROPPED_ITEMS_COUNT_NAME, this.getDroppedItemCount());
        CursedChestBlockEntity.putWeightedItemStackArray(nbt, NBT_AVAILABLE_ITEMS_NAME, this.availableItems);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.droppedItemCount = nbt.method_10550(NBT_DROPPED_ITEMS_COUNT_NAME);
        this.availableItems = CursedChestBlockEntity.getWeightedItemStackArray(nbt, NBT_AVAILABLE_ITEMS_NAME);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> PlayState.STOP).triggerableAnim("open", ANIMATION_OPEN)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public int getDroppedItemCount() {
        return Math.min(this.droppedItemCount, this.availableItems.length);
    }

    public void toggleReloading(boolean force) {
        boolean toggle = force | !this.isReloading();
        if (toggle) {
            this.reloadingTicks = 24;
        }
    }

    public boolean isReloading() {
        return this.reloadingTicks > 0;
    }
}

