/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalsoul.block.entity.logic.soulsreceptacle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_270;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3732;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.moddercoder.immortalsoul.block.SoulsReceptacleBlock;
import net.moddercoder.immortalsoul.block.entity.SoulsReceptacleBlockEntity;
import net.moddercoder.immortalsoul.sound.ModSoundEvents;
import net.moddercoder.immortalsoul.util.TimeableAction;
import org.jetbrains.annotations.Nullable;

public abstract class SoulsReceptacleLogic {
    public static final String NO_DAMAGE_TEAM_PREFIX_NAME = "immortalSoulNoDamageTeam";
    public static final String NBT_NO_DAMAGE_TEAM_NAME = "ImmortalSoulNoDamageTeamId";
    public static final int DEFAULT_SPAWN_PER_TIME = 4;
    public static final int DEFAULT_TOTAL_WAVE_COUNT = 2;
    public static final int MAX_PLAYERS_COUNT_MULTIPLIER = 3;
    public static final String DEFAULT_ENTITY_ID = "minecraft:pig";
    public static final int DEFAULT_CHECK_NEARBY_MOBS_RANGE = 12;
    public static final String NBT_CHECK_NEARBY_MOBS_RANGE_NAME = "CheckNearbyMobsRange";
    public static final String NBT_BREAK_INTERFRENCE_NAME = "IsBreakInterference";
    public static final String NBT_INCREMENTAL_WAVES_NAME = "IsIncrementalWaves";
    public static final String NBT_INCREMENTAL_FACTOR_NAME = "IncrementalFactor";
    public static final String NBT_EFFECTS_NAME = "PotionEffects";
    public static final String NBT_ARMOR_EQUIPMENT_NAME = "ArmorEquipments";
    public static final double PLAYER_DISTANCE_FOR_RESET_SPAWN_STATUS = 30.0;
    private class_268 noDamageTeam;
    private String noDamageTeamName;
    private boolean breakInterference = false;
    private class_1799[] armorEquipments = new class_1799[4];
    private ArrayList<class_1293> potionEffects = new ArrayList();
    private int spawnDelay = 100;
    private int minSpawnDelay = 100;
    private final int delayForCheckEntities = 20;
    private int checkNearbyMobsRange = 12;
    private int spawnRange = 5;
    @Nullable
    private class_1297 renderedEntity;
    private int maxNearbyEntities = 0;
    private int requiredPlayerRange = 15;
    private int waveCount = 0;
    private int totalWaveCount = 2;
    private int spawnPerTime = 4;
    private boolean firstWave = true;
    private boolean playerInRange = false;
    protected boolean incrementalWaves = false;
    protected float incrementFactor = 1.0f;
    @Nullable
    private TimeableAction spawnAction;
    @Nullable
    private class_1299<?> spawnEntityType = class_1299.field_6093;

    public static boolean hasNoDamageTeam(class_1297 entity) {
        class_270 entityTeam = entity.method_5781();
        if (entityTeam == null) {
            return false;
        }
        return entityTeam.method_1197().contains(NO_DAMAGE_TEAM_PREFIX_NAME);
    }

    public class_268 getTeam(class_1937 world) {
        if (world == null) {
            return null;
        }
        if (this.noDamageTeam == null) {
            if (this.noDamageTeamName == null) {
                this.noDamageTeamName = NO_DAMAGE_TEAM_PREFIX_NAME.concat(String.valueOf(world.field_9229.method_43048(Integer.MAX_VALUE)));
            }
            this.noDamageTeam = new class_268(world.method_8428(), this.noDamageTeamName);
            this.noDamageTeam.method_1135(false);
        }
        return this.noDamageTeam;
    }

    private boolean isPlayerInRange(class_1937 world, class_2338 pos) {
        return world.method_18458((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)this.requiredPlayerRange);
    }

    private boolean isNonCreativeAndSpectatorPlayerInRange(class_1937 world, class_2338 pos) {
        for (class_1657 playerEntity : world.method_18456()) {
            if (!class_1301.field_6156.test(playerEntity) || !class_1301.field_6157.test(playerEntity)) continue;
            double d = playerEntity.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            if (!((double)this.requiredPlayerRange < 0.0) && !(d < (double)(this.requiredPlayerRange * this.requiredPlayerRange))) continue;
            return true;
        }
        return false;
    }

    public void clientTick(class_1937 world, class_2338 pos, class_2680 state, SoulsReceptacleBlockEntity blockEntity) {
        if (world == null) {
            return;
        }
        if (world.method_18456().size() <= 0) {
            return;
        }
        boolean nonCreativeAndSpectatorPlayerInRange = this.isNonCreativeAndSpectatorPlayerInRange(world, pos);
        if (nonCreativeAndSpectatorPlayerInRange != this.playerInRange) {
            this.playerInRange = nonCreativeAndSpectatorPlayerInRange;
            this.onPlayerAppearInRange(world, pos, state, this.playerInRange);
        }
        class_5819 random = world.method_8409();
        double d = (double)pos.method_10263() + random.method_43058();
        double e = (double)pos.method_10264() + random.method_43058();
        double f = (double)pos.method_10260() + random.method_43058();
        Optional optionalBlockStateTurnedOn = world.method_8320(pos).method_28500((class_2769)SoulsReceptacleBlock.TURNED_ON);
        if (optionalBlockStateTurnedOn.isPresent() && ((Boolean)optionalBlockStateTurnedOn.get()).booleanValue()) {
            world.method_8406((class_2394)class_2398.field_11251, d, e, f, 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_22246, d, e, f, 0.0, 0.0, 0.0);
        } else {
            world.method_8406((class_2394)class_2398.field_11251, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    public void serverTick(class_3218 world, class_2338 pos, class_2680 state, SoulsReceptacleBlockEntity blockEntity) {
        int nearbyEntitiesWithTeamCount;
        boolean nonCreativeAndSpectatorPlayerInRange;
        if (world == null) {
            return;
        }
        if (world.method_18456().isEmpty() || !this.hasSpawnEntityType()) {
            return;
        }
        boolean playerInRange = this.isPlayerInRange((class_1937)world, pos);
        if (playerInRange && this.spawnAction != null) {
            this.spawnAction.update();
        }
        if ((nonCreativeAndSpectatorPlayerInRange = this.isNonCreativeAndSpectatorPlayerInRange((class_1937)world, pos)) != this.playerInRange) {
            this.playerInRange = nonCreativeAndSpectatorPlayerInRange;
            this.onPlayerAppearInRange((class_1937)world, pos, state, this.playerInRange);
        }
        int nonCreativeAndSpectatorPlayerInRangeCount = 0;
        if (!nonCreativeAndSpectatorPlayerInRange) {
            if (!this.isFirstWave()) {
                boolean needReset = true;
                List players = world.method_18766(class_1301.field_6156);
                for (class_3222 player : players) {
                    double squaredDistanceToPlayer = player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    if (!needReset || !(squaredDistanceToPlayer <= 900.0)) continue;
                    needReset = false;
                    break;
                }
                if (needReset) {
                    blockEntity.toggleReloading();
                    this.resetSpawnStatus();
                }
            }
            return;
        }
        List players = world.method_18766(class_1301.field_6156);
        for (class_3222 player : players) {
            double squaredDistanceToPlayer = player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (!(squaredDistanceToPlayer <= Math.pow(this.requiredPlayerRange + 5, 2.0))) continue;
            ++nonCreativeAndSpectatorPlayerInRangeCount;
        }
        int[] refNonCreativeAndSpectatorPlayerInRangeCount = new int[]{nonCreativeAndSpectatorPlayerInRangeCount};
        class_268 team = this.getTeam((class_1937)world);
        if (world.method_8503().method_3845().method_1153(team.method_1197()) == null) {
            world.method_8503().method_3845().method_1171(team.method_1197());
        }
        if (this.spawnAction == null) {
            this.spawnAction = new TimeableAction(() -> this.spawnMobsLogic(refNonCreativeAndSpectatorPlayerInRangeCount, world, pos, state, blockEntity));
            this.spawnAction.setOnStart(() -> {
                world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)SoulsReceptacleBlock.ACTIVATE, (Comparable)Boolean.valueOf(true)));
                world.method_8396(null, pos, ModSoundEvents.RECEPTACLE_OF_SOULS_GETTINGS_SPAWN, class_3419.field_15245, 1.0f, 1.0f);
            });
        } else {
            this.spawnAction.setOnEnd(() -> this.spawnMobsLogic(refNonCreativeAndSpectatorPlayerInRangeCount, world, pos, state, blockEntity));
        }
        long l = world.method_8510();
        Objects.requireNonNull(this);
        if (l % 20L == 0L && this.spawnAction != null && !this.spawnAction.isRunning() && (nearbyEntitiesWithTeamCount = world.method_8390(class_1308.class, new class_238(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).method_1014((double)this.checkNearbyMobsRange).method_996(pos), class_1301.field_6155.and(entity -> {
            if (entity.method_5781() != null) {
                return team.method_1197().equals(entity.method_5781().method_1197());
            }
            return false;
        })).size()) <= this.maxNearbyEntities) {
            if (this.spawnsEnd()) {
                world.method_8396(null, pos, class_3417.field_14688, class_3419.field_15245, 1.0f, 1.0f);
                blockEntity.toggleReloading();
                blockEntity.reward();
                this.firstWave = true;
                this.waveCount = 0;
            } else {
                if (this.firstWave) {
                    world.method_8396(null, pos, class_3417.field_14792, class_3419.field_15245, 1.0f, 1.0f);
                }
                this.spawnAction.start(this.spawnDelay);
            }
        }
    }

    private void spawnMobsLogic(int[] refPlayersCount, class_3218 world, class_2338 pos, class_2680 state, SoulsReceptacleBlockEntity blockEntity) {
        if (!this.spawnsEnd()) {
            class_1299<?> spawnEntityType = this.getSpawnEntityType();
            if (!spawnEntityType.method_5891().method_6136() && world.method_8407() == class_1267.field_5801) {
                return;
            }
            boolean yOffset = true;
            ArrayList<class_1308> entitiesForSpawn = new ArrayList<class_1308>();
            for (int i = 0; i < this.getSpawnPerTime(refPlayersCount[0]); ++i) {
                class_5819 random = world.method_8409();
                double spawnX = (double)pos.method_10263() + (random.method_43058() - random.method_43058()) * (double)this.spawnRange;
                double spawnY = pos.method_10264() + 1;
                double spawnZ = (double)pos.method_10260() + (random.method_43058() - random.method_43058()) * (double)this.spawnRange;
                if (!this.breakInterference && !world.method_18026(spawnEntityType.method_17683(spawnX, spawnY, spawnZ))) {
                    entitiesForSpawn.clear();
                    break;
                }
                class_1297 entity = spawnEntityType.method_5883((class_1937)world);
                if (entity == null) {
                    entitiesForSpawn.clear();
                    break;
                }
                entity.method_5808(spawnX, spawnY, spawnZ, random.method_43057() * 360.0f, 0.0f);
                if (!(entity instanceof class_1308)) {
                    entitiesForSpawn.clear();
                    break;
                }
                class_1308 mobEntity = (class_1308)entity;
                entitiesForSpawn.add(mobEntity);
            }
            if (this.breakInterference) {
                int xDistance;
                float maxEntityWidth = entitiesForSpawn.stream().map(class_1297::method_17681).max(Comparator.naturalOrder()).orElseGet(() -> Float.valueOf(0.0f)).floatValue();
                float maxEntityHeight = entitiesForSpawn.stream().map(class_1297::method_17682).max(Comparator.naturalOrder()).orElseGet(() -> Float.valueOf(0.0f)).floatValue();
                int zDistance = xDistance = this.spawnRange + (int)maxEntityWidth;
                class_2338.class_2339 mutableBlockPos = pos.method_25503();
                for (int zz = -zDistance; zz <= zDistance; ++zz) {
                    for (int xx = -xDistance; xx <= xDistance; ++xx) {
                        int yy = 0;
                        while ((float)yy < maxEntityHeight) {
                            world.method_22352(mutableBlockPos.method_10069(xx, 1 + yy, zz), true);
                            ++yy;
                        }
                    }
                }
            }
            if (!entitiesForSpawn.isEmpty() && entitiesForSpawn.size() == this.getSpawnPerTime(refPlayersCount[0])) {
                for (class_1308 spawnedEntity : entitiesForSpawn) {
                    class_2338 blockPos = spawnedEntity.method_24515();
                    spawnedEntity.method_5943((class_5425)world, world.method_8404(blockPos), class_3730.field_16469, null, null);
                    if (spawnedEntity instanceof class_5418) {
                        class_5418 abstractPiglinEntity = (class_5418)spawnedEntity;
                        abstractPiglinEntity.method_30240(true);
                        abstractPiglinEntity.method_7217(false);
                    }
                    if (spawnedEntity instanceof class_3732) {
                        class_3732 patrolEntity = (class_3732)spawnedEntity;
                        patrolEntity.method_16217(false);
                        patrolEntity.method_5673(class_1304.field_6169, class_1802.field_8162.method_7854());
                    }
                    world.method_30771((class_1297)spawnedEntity);
                    world.method_14170().method_1172(spawnedEntity.method_5820(), this.getTeam((class_1937)world));
                    if (this.armorEquipments != null) {
                        for (int i = 0; i < this.armorEquipments.length; ++i) {
                            class_1799 stackArmorEquipment = this.armorEquipments[i];
                            if (stackArmorEquipment == null || stackArmorEquipment.method_7960()) continue;
                            class_1304 equipmentSlot = class_1304.method_20234((class_1304.class_1305)class_1304.class_1305.field_6178, (int)i);
                            spawnedEntity.method_5673(equipmentSlot, stackArmorEquipment);
                            spawnedEntity.method_5946(equipmentSlot, 0.0f);
                        }
                    }
                    if (this.potionEffects != null && !this.potionEffects.isEmpty()) {
                        for (class_1293 statusEffectInstance : this.potionEffects) {
                            if (statusEffectInstance == null) continue;
                            spawnedEntity.method_6092(new class_1293(statusEffectInstance.method_5579(), statusEffectInstance.method_5584(), statusEffectInstance.method_5578(), statusEffectInstance.method_5591(), statusEffectInstance.method_5581(), statusEffectInstance.method_5592()));
                        }
                    }
                    world.method_20290(2004, pos, 0);
                    world.method_33596((class_1297)spawnedEntity, class_5712.field_28738, blockPos);
                    spawnedEntity.method_5990();
                }
                world.method_8396(null, pos, ModSoundEvents.RECEPTACLE_OF_SOULS_SPAWN, class_3419.field_15245, 1.0f, 0.8f);
                if (this.firstWave) {
                    this.firstWave = false;
                }
                ++this.waveCount;
            }
        }
        world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)SoulsReceptacleBlock.ACTIVATE, (Comparable)Boolean.valueOf(false)));
    }

    public void readNbt(@Nullable class_1937 world, class_2338 pos, class_2487 nbt) {
        int i;
        if (nbt.method_10573(NBT_ARMOR_EQUIPMENT_NAME, 9)) {
            class_2499 nbtListArmorEquipments = nbt.method_10554(NBT_ARMOR_EQUIPMENT_NAME, 10);
            for (i = 0; i < nbtListArmorEquipments.size(); ++i) {
                this.armorEquipments[i] = class_1799.method_7915((class_2487)nbtListArmorEquipments.method_10602(i));
            }
        }
        if (nbt.method_10573(NBT_EFFECTS_NAME, 9)) {
            this.potionEffects.clear();
            class_2499 nbtListStatusEffects = nbt.method_10554(NBT_EFFECTS_NAME, 10);
            for (i = 0; i < nbtListStatusEffects.size(); ++i) {
                this.potionEffects.add(class_1293.method_5583((class_2487)nbtListStatusEffects.method_10602(i)));
            }
        }
        if (nbt.method_10573(NBT_NO_DAMAGE_TEAM_NAME, 8)) {
            this.noDamageTeamName = nbt.method_10558(NBT_NO_DAMAGE_TEAM_NAME);
        }
        this.spawnDelay = nbt.method_10568("Delay");
        if (nbt.method_10573("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.method_10568("MaxNearbyEntities");
            this.requiredPlayerRange = nbt.method_10568("RequiredPlayerRange");
        }
        if (nbt.method_10573("SpawnRange", 99)) {
            this.spawnRange = nbt.method_10568("SpawnRange");
        }
        if (nbt.method_10573("IsFirstWave", 1)) {
            this.setFirstWave(nbt.method_10577("IsFirstWave"));
        }
        if (nbt.method_10573(NBT_CHECK_NEARBY_MOBS_RANGE_NAME, 1)) {
            this.checkNearbyMobsRange = nbt.method_10571(NBT_CHECK_NEARBY_MOBS_RANGE_NAME);
        }
        if (nbt.method_10573(NBT_BREAK_INTERFRENCE_NAME, 1)) {
            this.breakInterference = nbt.method_10577(NBT_BREAK_INTERFRENCE_NAME);
        }
        if (nbt.method_10573(NBT_INCREMENTAL_WAVES_NAME, 1)) {
            this.incrementalWaves = nbt.method_10577(NBT_INCREMENTAL_WAVES_NAME);
        }
        if (nbt.method_10573(NBT_INCREMENTAL_FACTOR_NAME, 5)) {
            this.incrementFactor = nbt.method_10583(NBT_INCREMENTAL_FACTOR_NAME);
        }
        if (nbt.method_10573("WaveCount", 1)) {
            this.waveCount = nbt.method_10571("WaveCount");
        }
        if (nbt.method_10573("TotalWaveCount", 1)) {
            this.totalWaveCount = nbt.method_10571("TotalWaveCount");
        }
        if (nbt.method_10573("SpawnPerTime", 1)) {
            this.spawnPerTime = nbt.method_10571("SpawnPerTime");
        }
        if (nbt.method_10573("SpawnEntity", 8)) {
            class_1299.method_5898((String)nbt.method_10558("SpawnEntity")).ifPresent(this::setSpawnEntityType);
        }
        this.renderedEntity = null;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        if (this.noDamageTeam != null) {
            nbt.method_10582(NBT_NO_DAMAGE_TEAM_NAME, this.noDamageTeam.method_1197());
        }
        class_2499 nbtListArmorEquipments = new class_2499();
        if (this.armorEquipments != null) {
            for (int i = 0; i < this.armorEquipments.length; ++i) {
                class_2487 nbtArmorEquipment = new class_2487();
                class_1799 armorEquipmentStack = this.armorEquipments[i];
                if (armorEquipmentStack != null && !armorEquipmentStack.method_7960()) {
                    armorEquipmentStack.method_7953(nbtArmorEquipment);
                }
                nbtListArmorEquipments.add((Object)nbtArmorEquipment);
            }
        }
        nbt.method_10566(NBT_ARMOR_EQUIPMENT_NAME, (class_2520)nbtListArmorEquipments);
        class_2499 nbtListPotionEffects = new class_2499();
        if (this.potionEffects != null) {
            for (int i = 0; i < this.potionEffects.size(); ++i) {
                class_1293 statusEffectInstance = this.potionEffects.get(i);
                if (statusEffectInstance == null) continue;
                class_2487 nbtStatusEffect = new class_2487();
                statusEffectInstance.method_5582(nbtStatusEffect);
                nbtListPotionEffects.add((Object)nbtStatusEffect);
            }
        }
        nbt.method_10566(NBT_EFFECTS_NAME, (class_2520)nbtListPotionEffects);
        nbt.method_10575("Delay", (short)this.spawnDelay);
        nbt.method_10575("MaxNearbyEntities", (short)this.maxNearbyEntities);
        nbt.method_10575("RequiredPlayerRange", (short)this.requiredPlayerRange);
        nbt.method_10575("SpawnRange", (short)this.spawnRange);
        nbt.method_10556("IsFirstWave", this.isFirstWave());
        nbt.method_10567(NBT_CHECK_NEARBY_MOBS_RANGE_NAME, (byte)this.checkNearbyMobsRange);
        nbt.method_10556(NBT_BREAK_INTERFRENCE_NAME, this.breakInterference);
        nbt.method_10556(NBT_INCREMENTAL_WAVES_NAME, this.incrementalWaves);
        nbt.method_10548(NBT_INCREMENTAL_FACTOR_NAME, this.incrementFactor);
        nbt.method_10567("WaveCount", (byte)this.waveCount);
        nbt.method_10567("TotalWaveCount", (byte)this.totalWaveCount);
        nbt.method_10567("SpawnPerTime", (byte)this.spawnPerTime);
        if (this.hasSpawnEntityType()) {
            nbt.method_10582("SpawnEntity", class_1299.method_5890(this.getSpawnEntityType()).toString());
        }
        return nbt;
    }

    public void setSpawnEntityType(class_1299<?> spawnEntityType) {
        if (spawnEntityType != this.spawnEntityType) {
            this.spawnEntityType = spawnEntityType;
        }
    }

    @Nullable
    public class_1299<?> getSpawnEntityType() {
        return this.spawnEntityType;
    }

    public boolean hasSpawnEntityType() {
        return this.spawnEntityType != null;
    }

    public boolean handleStatus(class_1937 world, int status) {
        if (status == 1) {
            if (world.field_9236) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public int getSpawnPerTime(int playersCount) {
        return (this.spawnPerTime + (this.incrementalWaves ? Math.round((float)this.waveCount * this.incrementFactor) : 0)) * Math.min(playersCount, 3);
    }

    public boolean spawnsEnd() {
        return this.waveCount >= this.totalWaveCount;
    }

    public void resetSpawnStatus() {
        this.waveCount = 0;
        this.firstWave = true;
        if (this.spawnAction != null) {
            this.spawnAction.stop();
        }
    }

    public SoulsReceptacleBlockEntity getBlockEntity(class_1937 world, class_2338 pos) {
        if (world.method_8321(pos) != null) {
            SoulsReceptacleBlockEntity receptacleBlockEntity;
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof SoulsReceptacleBlockEntity ? (receptacleBlockEntity = (SoulsReceptacleBlockEntity)class_25862) : null;
        }
        return null;
    }

    public void onPlayerAppearInRange(class_1937 world, class_2338 pos, class_2680 state, boolean appear) {
    }

    public abstract void sendStatus(class_1937 var1, class_2338 var2, int var3);

    public void setFirstWave(boolean value) {
        this.firstWave = value;
    }

    public boolean isFirstWave() {
        return this.firstWave;
    }

    @Nullable
    public class_1297 getRenderedEntity(class_1937 world) {
        return null;
    }
}

