/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.utils;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ParticleBuilder {
    private final double ANGLE_CIRCLE = Math.PI * 2;
    private final double angleParticle;
    private final int count;
    private double angle;
    private Vector3f color;

    public ParticleBuilder(int count) {
        this.count = count;
        this.angleParticle = Math.PI * 2 / (double)count;
    }

    public ParticleBuilder setColor(Vector3f color) {
        this.color = color;
        return this;
    }

    public void spawnCircleParticle(ClientLevel clientWorld, double posX, double posY, double posZ, double radius, float time) {
        for (int i = 0; i < this.count; ++i) {
            this.angle = (double)i * this.angleParticle + (double)time * (Math.PI * 2);
            clientWorld.m_7106_((ParticleOptions)new DustParticleOptions(this.color, 1.0f), posX + radius * Math.cos(this.angle), posY, posZ + radius * Math.sin(this.angle), 0.0, 0.0, 0.0);
        }
    }

    public void spawnCircleParticleColors(ClientLevel clientWorld, double posX, double posY, double posZ, double radius, float time) {
        for (int i = 0; i < this.count; ++i) {
            this.angle = (double)i * this.angleParticle + (double)time * (Math.PI * 2);
            clientWorld.m_7106_((ParticleOptions)new DustParticleOptions(this.color, 0.8f), posX + radius * Math.cos(this.angle), posY, posZ + radius * Math.sin(this.angle), 0.0, 0.0, 0.0);
        }
    }

    public void spawnCircleParticleWithTime(ClientLevel clientWorld, double posX, double posY, double posZ, double radius, float speed) {
        this.angle = (double)((float)clientWorld.m_46467_() * speed) * (Math.PI / 180);
        for (int i = 0; i < this.count; ++i) {
            double particleAngle = this.angle + Math.PI * 2 * (double)i / (double)this.count;
            double particleOffsetX = Math.cos(particleAngle) * radius;
            double particleOffsetZ = Math.sin(particleAngle) * radius;
            Vec3 particlePos = new Vec3(posX + particleOffsetX, posY, posZ + particleOffsetZ);
            clientWorld.m_7106_((ParticleOptions)new DustParticleOptions(this.color, 0.8f), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public void spawnParticle(ClientLevel clientWorld, double posX, double posY, double posZ) {
        clientWorld.m_7106_((ParticleOptions)new DustParticleOptions(this.color, 0.8f), posX, posY, posZ, 0.0, 0.0, 0.0);
    }

    public void spawnParticle(ClientLevel clientWorld, Vec3 position, double spread) {
        clientWorld.m_7106_((ParticleOptions)new DustParticleOptions(this.color, 0.8f), position.f_82479_, position.f_82480_, position.f_82481_, spread, spread, spread);
    }

    public void spawnParticles(ServerLevel level, Vec3 position, double spread, double speed) {
        level.m_8767_((ParticleOptions)new DustParticleOptions(this.color, 0.8f), position.f_82479_, position.f_82480_, position.f_82481_, this.count, spread, spread, spread, speed);
    }

    public void spawnRandomAroundParticles(ClientLevel level, Vec3 position, double spread, double speed) {
        Random random = new Random();
        for (int i = 0; i < this.count; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * spread;
            double offsetY = (random.nextDouble() - 0.5) * spread;
            double offsetZ = (random.nextDouble() - 0.5) * spread;
            double velocityX = (random.nextDouble() - 0.5) * speed;
            double velocityY = (random.nextDouble() - 0.5) * speed;
            double velocityZ = (random.nextDouble() - 0.5) * speed;
            level.m_7106_((ParticleOptions)new DustParticleOptions(this.color, 1.2f), position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, velocityX, velocityY, velocityZ);
        }
    }
}

