/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.utils;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class CoordinatesHelper {
    public static Vec3 getRandomSurfacePosition(Level world, BlockPos center, int radius) {
        Random random = new Random();
        int x = center.m_123341_() + random.nextInt(radius * 2) - radius;
        int z = center.m_123343_() + random.nextInt(radius * 2) - radius;
        int y = world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static Vec3 getRandomFreePositionForEntity(Level world, BlockPos center, Entity entity, int radius) {
        ArrayList<BlockPos> suitablePositions = new ArrayList<BlockPos>();
        Random random = new Random();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    BlockPos pos = center.m_7918_(x, y, z);
                    if (!CoordinatesHelper.isSuitableForSpawn(world, pos, entity)) continue;
                    suitablePositions.add(pos);
                }
            }
        }
        if (!suitablePositions.isEmpty()) {
            BlockPos randomPos = (BlockPos)suitablePositions.get(random.nextInt(suitablePositions.size()));
            return new Vec3((double)randomPos.m_123341_(), (double)randomPos.m_123342_(), (double)randomPos.m_123343_());
        }
        return null;
    }

    public static boolean isSuitableForSpawn(Level world, BlockPos pos, Entity entity) {
        BlockState state = world.m_8055_(pos);
        BlockState belowState = world.m_8055_(pos.m_7495_());
        boolean isNotSolid = state.m_60795_();
        boolean isAboveEmpty = world.m_46859_(pos.m_7494_());
        boolean isBelowSolid = belowState.m_280296_();
        return isNotSolid && isAboveEmpty && isBelowSolid;
    }
}

