/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.recipe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.recipe.RarityRecipe;
import ru.xewe.immortal.recipe.RequireStack;
import ru.xewe.immortal.utils.ItemRarityHelper;

public class AltarRecipeManager {
    private static final Map<Item, RarityRecipe> RECIPES = new HashMap<Item, RarityRecipe>();

    public static <T extends Item> void addRecipe(RegistryObject<T> item, RarityRecipe recipe) {
        RECIPES.put((Item)item.get(), recipe);
    }

    public static <T extends Item> void addRecipe(T result, RarityRecipe recipe) {
        RECIPES.put(result, recipe);
    }

    public static <T extends AbstractRarityArmor<T>> void addRecipe(ArmorSet<T> result, RarityRecipe recipe) {
        for (AbstractRarityArmor armor : result.getListItems()) {
            AltarRecipeManager.addRecipe(armor, recipe);
        }
    }

    public static boolean canUpgrade(ItemStack targetStack, List<ItemStack> inputs) {
        RarityRecipe recipe = RECIPES.get(targetStack.m_41720_());
        return recipe != null && recipe.canCraft(inputs, ItemRarityHelper.getRarity(targetStack));
    }

    public static String getRequiredItemsToLocalize(ItemStack target) {
        RarityRecipe recipe = RECIPES.get(target.m_41720_());
        RequireStack[] required = recipe.getRequirements().get((Object)ItemRarityHelper.getRarity(target));
        if (required == null) {
            return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442";
        }
        StringBuilder result = new StringBuilder();
        for (RequireStack requireStack : required) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(requireStack.getResourceLocation());
            ItemStack itemStack = item != null ? new ItemStack((ItemLike)item) : ItemStack.f_41583_;
            String name = !itemStack.m_41619_() ? itemStack.m_41786_().getString() : requireStack.id();
            result.append("\u00a72").append(requireStack.count()).append("x \u00a7r").append(name).append("\n");
        }
        return result.toString();
    }

    public static void init() {
        String bornInChaos_darkMetalNugget = "born_in_chaos_v1:dark_metal_nugget";
        String bornInChaos_armorPlateFromDarkMetal = "born_in_chaos_v1:armor_plate_from_dark_metal";
        String minecraft_diamond = "minecraft:diamond";
        String minecraft_netheriteIngot = "minecraft:netherite_ingot";
        String minecraft_ironIngot = "minecraft:iron_ingot";
        String isb_arcane_essence = "irons_spellbooks:arcane_essence";
        RarityRecipe inquisitor = new RarityRecipe(Map.of(ItemRarity.COMMON, new RequireStack[]{new RequireStack("born_in_chaos_v1:dark_metal_nugget", 2), new RequireStack("minecraft:iron_ingot", 2)}, ItemRarity.RARE, new RequireStack[]{new RequireStack("minecraft:diamond", 2), new RequireStack("born_in_chaos_v1:dark_metal_ingot", 2)}, ItemRarity.EPIC, new RequireStack[]{new RequireStack("minecraft:netherite_ingot", 1), new RequireStack("born_in_chaos_v1:armor_plate_from_dark_metal", 1), new RequireStack("minecraft:diamond", 2)}));
        RarityRecipe elderWizard = new RarityRecipe(Map.of(ItemRarity.COMMON, new RequireStack[]{new RequireStack("irons_spellbooks:arcane_essence", 2), new RequireStack("minecraft:iron_ingot", 2)}, ItemRarity.RARE, new RequireStack[]{new RequireStack("minecraft:diamond", 2), new RequireStack("irons_spellbooks:arcane_ingot", 2)}, ItemRarity.EPIC, new RequireStack[]{new RequireStack("minecraft:netherite_ingot", 1), new RequireStack("irons_spellbooks:arcane_ingot", 1), new RequireStack("minecraft:diamond", 2)}));
        RarityRecipe engineer = new RarityRecipe(Map.of(ItemRarity.COMMON, new RequireStack[]{new RequireStack("create:zinc_ingot", 2), new RequireStack("minecraft:iron_ingot", 2)}, ItemRarity.RARE, new RequireStack[]{new RequireStack("minecraft:diamond", 2), new RequireStack("create:brass_ingot", 2)}, ItemRarity.EPIC, new RequireStack[]{new RequireStack("minecraft:netherite_ingot", 1), new RequireStack("create:brass_sheet", 1), new RequireStack("minecraft:diamond", 2)}));
        RarityRecipe mechanical = new RarityRecipe(Map.of(ItemRarity.COMMON, new RequireStack[]{new RequireStack("create:zinc_ingot", 2), new RequireStack("minecraft:iron_ingot", 2)}, ItemRarity.RARE, new RequireStack[]{new RequireStack("minecraft:diamond", 2), new RequireStack("create:brass_ingot", 2)}, ItemRarity.EPIC, new RequireStack[]{new RequireStack("minecraft:netherite_ingot", 1), new RequireStack("create:precision_mechanism", 1), new RequireStack("minecraft:diamond", 2)}));
        RarityRecipe unholy = new RarityRecipe(Map.of(ItemRarity.COMMON, new RequireStack[]{new RequireStack("born_in_chaos_v1:dark_metal_nugget", 2), new RequireStack("minecraft:iron_ingot", 2)}, ItemRarity.RARE, new RequireStack[]{new RequireStack("minecraft:diamond", 2), new RequireStack("born_in_chaos_v1:dark_metal_ingot", 2)}, ItemRarity.EPIC, new RequireStack[]{new RequireStack("minecraft:netherite_ingot", 1), new RequireStack("born_in_chaos_v1:transformative_flower", 1), new RequireStack("minecraft:diamond", 2)}));
        RarityRecipe elementalist = new RarityRecipe(Map.of(ItemRarity.COMMON, new RequireStack[]{new RequireStack("irons_spellbooks:arcane_essence", 2), new RequireStack("minecraft:iron_ingot", 2)}, ItemRarity.RARE, new RequireStack[]{new RequireStack("minecraft:diamond", 2), new RequireStack("irons_spellbooks:arcane_ingot", 2)}, ItemRarity.EPIC, new RequireStack[]{new RequireStack("minecraft:netherite_ingot", 1), new RequireStack("irons_spellbooks:arcane_ingot", 1), new RequireStack("minecraft:diamond", 2)}));
        AltarRecipeManager.addRecipe(RegisterManagerItems.DARK_INQUISITOR_SWORD, inquisitor);
        AltarRecipeManager.addRecipe(RegisterManagerItems.DARK_ORDEN_INQUISITOR_SET, inquisitor);
        AltarRecipeManager.addRecipe(RegisterManagerItems.ELDER_WIZARD_BOOK, elderWizard);
        AltarRecipeManager.addRecipe(RegisterManagerItems.ELDER_WIZARD_SET, elderWizard);
        AltarRecipeManager.addRecipe(RegisterManagerItems.ENGINEER_STAFF, engineer);
        AltarRecipeManager.addRecipe(RegisterManagerItems.ENGINEER_SET, engineer);
        AltarRecipeManager.addRecipe(RegisterManagerItems.MECHANICAL_HUMMER, mechanical);
        AltarRecipeManager.addRecipe(RegisterManagerItems.MECHANICAL_MESSENGER_SET, mechanical);
        AltarRecipeManager.addRecipe(RegisterManagerItems.UNHOLY_KNIGHT_MACE, unholy);
        AltarRecipeManager.addRecipe(RegisterManagerItems.UNHOLY_KNIGHT_SET, unholy);
        AltarRecipeManager.addRecipe(RegisterManagerItems.ELEMENTALIST_STAFF, elementalist);
        AltarRecipeManager.addRecipe(RegisterManagerItems.ELEMENTALIST_SET, elementalist);
    }
}

