/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3f;
import ru.xewe.immortal.network.ctx.IModPacket;
import ru.xewe.immortal.utils.ParticleBuilder;

public class HitSpawnParticleToC
implements IModPacket {
    private Vec3 position;
    private Vector3f color;

    public HitSpawnParticleToC(Vec3 position, Vector3f color) {
        this.position = position;
        this.color = color;
    }

    public HitSpawnParticleToC(FriendlyByteBuf buf) {
        this.position = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.color = buf.m_269394_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.position.f_82479_);
        buf.writeDouble(this.position.f_82480_);
        buf.writeDouble(this.position.f_82481_);
        buf.m_269582_(this.color);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                ParticleBuilder particleBuilder = new ParticleBuilder(40).setColor(this.color);
                particleBuilder.spawnRandomAroundParticles(level, this.position, 3.0, 1.0);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

