/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.weapons;

import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.effect.RegisterManagerEffects;
import ru.xewe.immortal.events.TimeableManager;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.weapons.AbstractRarityWeapon;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;

public class UnholyKnightMace
extends AbstractRarityWeapon<UnholyKnightMace> {
    private static final int ABILITY_COOLDOWN = 400;

    public UnholyKnightMace(Item.Properties properties) {
        super(properties);
    }

    @Override
    public RegistryObject<UnholyKnightMace> getVariant() {
        return RegisterManagerItems.UNHOLY_KNIGHT_MACE;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            UnholyKnightMace mace;
            Player player = (Player)attacker;
            Item item = stack.m_41720_();
            if (item instanceof UnholyKnightMace && (mace = (UnholyKnightMace)item).hasSkill(stack)) {
                Level world = player.m_9236_();
                if (this.isNotCooldown(player, InteractionHand.MAIN_HAND) && SuperpositionHandler.isTheCursedOne((Player)player)) {
                    this.onAbility(world, stack, target, player);
                }
                if (target.m_21223_() <= 0.0f) {
                    this.onKillEnemy(stack, target, player);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public float m_43299_() {
        return super.m_43299_() + 2.0f;
    }

    private void onKillEnemy(ItemStack stack, LivingEntity target, Player player) {
        float currentDamage;
        if (target.m_21023_((MobEffect)RegisterManagerEffects.BURIAL_EFFECT.get()) && (currentDamage = stack.m_41784_().m_128457_("BonusDamage")) < 13.0f) {
            stack.m_41784_().m_128350_("BonusDamage", currentDamage += 0.1f);
        }
    }

    private void onAbility(Level world, ItemStack stack, LivingEntity target, Player player) {
        if (!this.isEntityFlying(target)) {
            target.m_7292_(new MobEffectInstance((MobEffect)RegisterManagerEffects.BURIAL_EFFECT.get(), 60, 0));
            world.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11668_, SoundSource.BLOCKS, 1.0f, 1.0f);
            target.m_6034_(target.m_20185_(), target.m_20186_() - 1.0, target.m_20189_());
            TimeableManager.postDelayed(() -> target.m_6034_(target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_()), 60);
            this.setCooldown(player, 400, InteractionHand.MAIN_HAND);
        }
    }

    public boolean isEntityFlying(LivingEntity entity) {
        boolean isFly = entity instanceof FlyingMob || entity instanceof FlyingAnimal;
        boolean isOnGround = entity.m_20096_();
        return isFly && !isOnGround;
    }

    @Override
    public List<RarityTiers> getRarityMaterials() {
        return List.of(RarityTiers.COMMON_UNHOLY, RarityTiers.RARE_UNHOLY, RarityTiers.EPIC_UNHOLY, RarityTiers.LEGENDARY_UNHOLY);
    }
}

