/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.weapons;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.client.sounds.RegisterManagerSound;
import ru.xewe.immortal.entity.projectiles.AbstractMagicProjectile;
import ru.xewe.immortal.entity.projectiles.FireProjectile;
import ru.xewe.immortal.entity.projectiles.IceProjectile;
import ru.xewe.immortal.entity.projectiles.NatureProjectile;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.weapons.AbstractRarityWeapon;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;

public class ElementalistStuff
extends AbstractRarityWeapon<ElementalistStuff> {
    private static final int REQ_MANA = 60;
    public static final int COOLDOWN_ABILITY = 40;

    public ElementalistStuff(Item.Properties properties) {
        super(properties);
    }

    @Override
    public RegistryObject<ElementalistStuff> getVariant() {
        return RegisterManagerItems.ELEMENTALIST_STAFF;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ElementalistStuff transformedStuff;
        Item item;
        ItemStack stack = player.m_21120_(usedHand);
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)player);
        if (!level.f_46443_ && (item = stack.m_41720_()) instanceof ElementalistStuff && (transformedStuff = (ElementalistStuff)item).hasSkill(stack)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (magicData.getMana() >= 60.0f) {
                    float newMana = Math.max(magicData.getMana() - 60.0f, 0.0f);
                    magicData.setMana(newMana);
                    Messages.sendToPlayer((Object)new ClientboundSyncMana(magicData), (ServerPlayer)serverPlayer);
                    this.shootRandomProjectile(level, (Player)serverPlayer);
                    this.setCooldown(player, 40, usedHand);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                player.m_5661_((Component)Component.m_237113_((String)"\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043c\u0430\u043d\u044b!").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void shootRandomProjectile(Level world, Player player) {
        world.m_5594_(null, player.m_20183_(), (SoundEvent)RegisterManagerSound.FIREBALL.get(), SoundSource.PLAYERS, 0.3f, 1.0f);
        Random random = new Random();
        int projectileType = random.nextInt(3);
        AbstractMagicProjectile projectile = switch (projectileType) {
            case 0 -> new FireProjectile(world, player);
            case 1 -> new IceProjectile(world, player);
            default -> new NatureProjectile(world, player);
        };
        projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.7f, 1.0f);
        world.m_7967_((Entity)projectile);
    }

    @Override
    public List<RarityTiers> getRarityMaterials() {
        return List.of(RarityTiers.COMMON_WIZARDRY, RarityTiers.RARE_WIZARDRY, RarityTiers.EPIC_WIZARDRY, RarityTiers.LEGENDARY_WIZARDRY);
    }
}

